package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters.*
final case class Relationship(
    `type`: Option[zio.aws.textract.model.RelationshipType] = None,
    ids: Option[Iterable[NonEmptyString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.Relationship = {
    import Relationship.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Relationship
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        ids.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.ids)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Relationship.ReadOnly =
    zio.aws.textract.model.Relationship.wrap(buildAwsValue())
}
object Relationship {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.Relationship
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Relationship = zio.aws.textract.model
      .Relationship(`type`.map(value => value), ids.map(value => value))
    def `type`: Option[zio.aws.textract.model.RelationshipType]
    def ids: Option[List[NonEmptyString]]
    def getType: ZIO[Any, AwsError, zio.aws.textract.model.RelationshipType] =
      AwsError.unwrapOptionField("type", `type`)
    def getIds: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("ids", ids)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Relationship
  ) extends zio.aws.textract.model.Relationship.ReadOnly {
    override val `type`: Option[zio.aws.textract.model.RelationshipType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.textract.model.RelationshipType.wrap(value))
    override val ids: Option[List[NonEmptyString]] = scala
      .Option(impl.ids())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Relationship
  ): zio.aws.textract.model.Relationship.ReadOnly = new Wrapper(impl)
}
