package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.{S3ObjectName, S3Bucket}
import scala.jdk.CollectionConverters.*
final case class OutputConfig(
    s3Bucket: S3Bucket,
    s3Prefix: Option[S3ObjectName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.OutputConfig = {
    import OutputConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.OutputConfig
      .builder()
      .s3Bucket(S3Bucket.unwrap(s3Bucket): java.lang.String)
      .optionallyWith(
        s3Prefix.map(value => S3ObjectName.unwrap(value): java.lang.String)
      )(_.s3Prefix)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.OutputConfig.ReadOnly =
    zio.aws.textract.model.OutputConfig.wrap(buildAwsValue())
}
object OutputConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.OutputConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.OutputConfig = zio.aws.textract.model
      .OutputConfig(s3Bucket, s3Prefix.map(value => value))
    def s3Bucket: S3Bucket
    def s3Prefix: Option[S3ObjectName]
    def getS3Bucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(s3Bucket)
    def getS3Prefix: ZIO[Any, AwsError, S3ObjectName] =
      AwsError.unwrapOptionField("s3Prefix", s3Prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.OutputConfig
  ) extends zio.aws.textract.model.OutputConfig.ReadOnly {
    override val s3Bucket: S3Bucket =
      zio.aws.textract.model.primitives.S3Bucket(impl.s3Bucket())
    override val s3Prefix: Option[S3ObjectName] = scala
      .Option(impl.s3Prefix())
      .map(value => zio.aws.textract.model.primitives.S3ObjectName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.OutputConfig
  ): zio.aws.textract.model.OutputConfig.ReadOnly = new Wrapper(impl)
}
