package zio.aws.textract.model
import scala.jdk.CollectionConverters.*
sealed trait ValueType {
  def unwrap: software.amazon.awssdk.services.textract.model.ValueType
}
object ValueType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.ValueType
  ): zio.aws.textract.model.ValueType = value match {
    case software.amazon.awssdk.services.textract.model.ValueType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.ValueType.DATE =>
      val r = DATE
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.ValueType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.ValueType =
      software.amazon.awssdk.services.textract.model.ValueType.UNKNOWN_TO_SDK_VERSION
  }
  case object DATE extends zio.aws.textract.model.ValueType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.ValueType =
      software.amazon.awssdk.services.textract.model.ValueType.DATE
  }
}
