package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.JobId
import scala.jdk.CollectionConverters.*
final case class StartDocumentAnalysisResponse(jobId: Option[JobId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse = {
    import StartDocumentAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse
      .builder()
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly =
    zio.aws.textract.model.StartDocumentAnalysisResponse.wrap(buildAwsValue())
}
object StartDocumentAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.StartDocumentAnalysisResponse =
      zio.aws.textract.model
        .StartDocumentAnalysisResponse(jobId.map(value => value))
    def jobId: Option[JobId]
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse
  ) extends zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly {
    override val jobId: Option[JobId] = scala
      .Option(impl.jobId())
      .map(value => zio.aws.textract.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentAnalysisResponse
  ): zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly =
    new Wrapper(impl)
}
