package zio.aws.textract.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.UInteger
import scala.jdk.CollectionConverters.*
final case class IdentityDocument(
    documentIndex: Option[UInteger] = None,
    identityDocumentFields: Option[
      Iterable[zio.aws.textract.model.IdentityDocumentField]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.IdentityDocument = {
    import IdentityDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.IdentityDocument
      .builder()
      .optionallyWith(
        documentIndex.map(value => UInteger.unwrap(value): Integer)
      )(_.documentIndex)
      .optionallyWith(
        identityDocumentFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityDocumentFields)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.IdentityDocument.ReadOnly =
    zio.aws.textract.model.IdentityDocument.wrap(buildAwsValue())
}
object IdentityDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.IdentityDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.IdentityDocument =
      zio.aws.textract.model.IdentityDocument(
        documentIndex.map(value => value),
        identityDocumentFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentIndex: Option[UInteger]
    def identityDocumentFields
        : Option[List[zio.aws.textract.model.IdentityDocumentField.ReadOnly]]
    def getDocumentIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("documentIndex", documentIndex)
    def getIdentityDocumentFields: ZIO[Any, AwsError, List[
      zio.aws.textract.model.IdentityDocumentField.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "identityDocumentFields",
      identityDocumentFields
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.IdentityDocument
  ) extends zio.aws.textract.model.IdentityDocument.ReadOnly {
    override val documentIndex: Option[UInteger] = scala
      .Option(impl.documentIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val identityDocumentFields
        : Option[List[zio.aws.textract.model.IdentityDocumentField.ReadOnly]] =
      scala
        .Option(impl.identityDocumentFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.IdentityDocumentField.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.IdentityDocument
  ): zio.aws.textract.model.IdentityDocument.ReadOnly = new Wrapper(impl)
}
