package zio.aws.textract.model
import scala.jdk.CollectionConverters.*
sealed trait EntityType {
  def unwrap: software.amazon.awssdk.services.textract.model.EntityType
}
object EntityType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.EntityType
  ): zio.aws.textract.model.EntityType = value match {
    case software.amazon.awssdk.services.textract.model.EntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.EntityType.KEY =>
      val r = KEY
      r
    case software.amazon.awssdk.services.textract.model.EntityType.VALUE =>
      val r = VALUE
      r
    case software.amazon.awssdk.services.textract.model.EntityType.COLUMN_HEADER =>
      val r = COLUMN_HEADER
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object KEY extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.KEY
  }
  case object VALUE extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.VALUE
  }
  case object COLUMN_HEADER extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.COLUMN_HEADER
  }
}
