package zio.aws.textract
import zio.aws.textract.model.DetectDocumentTextResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.textract.model.{
  StartExpenseAnalysisResponse,
  StartDocumentTextDetectionRequest,
  AnalyzeIdResponse,
  StartDocumentAnalysisResponse,
  GetDocumentAnalysisRequest,
  Block,
  AnalyzeExpenseRequest,
  GetDocumentTextDetectionRequest,
  GetDocumentTextDetectionResponse,
  AnalyzeIdRequest,
  AnalyzeExpenseResponse,
  GetExpenseAnalysisResponse,
  StartDocumentTextDetectionResponse,
  StartDocumentAnalysisRequest,
  DetectDocumentTextRequest,
  GetDocumentAnalysisResponse,
  AnalyzeDocumentRequest,
  GetExpenseAnalysisRequest,
  AnalyzeDocumentResponse,
  StartExpenseAnalysisRequest,
  DetectDocumentTextResponse
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.textract.{
  TextractAsyncClientBuilder,
  TextractAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import scala.jdk.CollectionConverters.*
trait Textract extends AspectSupport[Textract] {
  val api: TextractAsyncClient
  def startExpenseAnalysis(
      request: zio.aws.textract.model.StartExpenseAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly]
  def getDocumentAnalysis(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]]
  def getDocumentAnalysisPaginated(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly]
  def analyzeExpense(
      request: zio.aws.textract.model.AnalyzeExpenseRequest
  ): IO[AwsError, zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly]
  def detectDocumentText(
      request: zio.aws.textract.model.DetectDocumentTextRequest
  ): IO[AwsError, ReadOnly]
  def startDocumentAnalysis(
      request: zio.aws.textract.model.StartDocumentAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly]
  def analyzeDocument(
      request: zio.aws.textract.model.AnalyzeDocumentRequest
  ): IO[AwsError, zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly]
  def getExpenseAnalysis(
      request: zio.aws.textract.model.GetExpenseAnalysisRequest
  ): IO[AwsError, zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly]
  def analyzeID(
      request: zio.aws.textract.model.AnalyzeIdRequest
  ): IO[AwsError, zio.aws.textract.model.AnalyzeIdResponse.ReadOnly]
  def startDocumentTextDetection(
      request: zio.aws.textract.model.StartDocumentTextDetectionRequest
  ): IO[
    AwsError,
    zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
  ]
  def getDocumentTextDetection(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]]
  def getDocumentTextDetectionPaginated(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): IO[
    AwsError,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
  ]
}
object Textract {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Textract] = customized(
    identity
  )
  def customized(
      customization: TextractAsyncClientBuilder => TextractAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Textract] = managed(
    customization
  ).toLayer
  def managed(
      customization: TextractAsyncClientBuilder => TextractAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Textract] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = TextractAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[TextractAsyncClient, TextractAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[TextractAsyncClient, TextractAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new TextractImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class TextractImpl[R](
      override val api: TextractAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Textract
      with AwsServiceBase[R] {
    override val serviceName: String = "Textract"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): TextractImpl[R1] = new TextractImpl(api, newAspect, r)
    def startExpenseAnalysis(
        request: zio.aws.textract.model.StartExpenseAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      StartExpenseAnalysisRequest,
      StartExpenseAnalysisResponse
    ]("startExpenseAnalysis", api.startExpenseAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.StartExpenseAnalysisResponse.wrap)
      .provideEnvironment(r)
    def getDocumentAnalysis(
        request: zio.aws.textract.model.GetDocumentAnalysisRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
      zio.aws.textract.model.Block.ReadOnly
    ]] = asyncPaginatedRequest[
      GetDocumentAnalysisRequest,
      GetDocumentAnalysisResponse,
      Block
    ](
      "getDocumentAnalysis",
      api.getDocumentAnalysis,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.blocks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(zio.aws.textract.model.GetDocumentAnalysisResponse.wrap)
          .mapOutput(_.map(item => zio.aws.textract.model.Block.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getDocumentAnalysisPaginated(
        request: zio.aws.textract.model.GetDocumentAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentAnalysisRequest,
      GetDocumentAnalysisResponse
    ]("getDocumentAnalysis", api.getDocumentAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.GetDocumentAnalysisResponse.wrap)
      .provideEnvironment(r)
    def analyzeExpense(
        request: zio.aws.textract.model.AnalyzeExpenseRequest
    ): IO[AwsError, zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly] =
      asyncRequestResponse[AnalyzeExpenseRequest, AnalyzeExpenseResponse](
        "analyzeExpense",
        api.analyzeExpense
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.AnalyzeExpenseResponse.wrap)
        .provideEnvironment(r)
    def detectDocumentText(
        request: zio.aws.textract.model.DetectDocumentTextRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      DetectDocumentTextRequest,
      DetectDocumentTextResponse
    ]("detectDocumentText", api.detectDocumentText)(request.buildAwsValue())
      .map(zio.aws.textract.model.DetectDocumentTextResponse.wrap)
      .provideEnvironment(r)
    def startDocumentAnalysis(
        request: zio.aws.textract.model.StartDocumentAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDocumentAnalysisRequest,
      StartDocumentAnalysisResponse
    ]("startDocumentAnalysis", api.startDocumentAnalysis)(
      request.buildAwsValue()
    ).map(zio.aws.textract.model.StartDocumentAnalysisResponse.wrap)
      .provideEnvironment(r)
    def analyzeDocument(
        request: zio.aws.textract.model.AnalyzeDocumentRequest
    ): IO[AwsError, zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly] =
      asyncRequestResponse[AnalyzeDocumentRequest, AnalyzeDocumentResponse](
        "analyzeDocument",
        api.analyzeDocument
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.AnalyzeDocumentResponse.wrap)
        .provideEnvironment(r)
    def getExpenseAnalysis(
        request: zio.aws.textract.model.GetExpenseAnalysisRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
    ] = asyncRequestResponse[
      GetExpenseAnalysisRequest,
      GetExpenseAnalysisResponse
    ]("getExpenseAnalysis", api.getExpenseAnalysis)(request.buildAwsValue())
      .map(zio.aws.textract.model.GetExpenseAnalysisResponse.wrap)
      .provideEnvironment(r)
    def analyzeID(
        request: zio.aws.textract.model.AnalyzeIdRequest
    ): IO[AwsError, zio.aws.textract.model.AnalyzeIdResponse.ReadOnly] =
      asyncRequestResponse[AnalyzeIdRequest, AnalyzeIdResponse](
        "analyzeID",
        api.analyzeID
      )(request.buildAwsValue())
        .map(zio.aws.textract.model.AnalyzeIdResponse.wrap)
        .provideEnvironment(r)
    def startDocumentTextDetection(
        request: zio.aws.textract.model.StartDocumentTextDetectionRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      StartDocumentTextDetectionRequest,
      StartDocumentTextDetectionResponse
    ]("startDocumentTextDetection", api.startDocumentTextDetection)(
      request.buildAwsValue()
    ).map(zio.aws.textract.model.StartDocumentTextDetectionResponse.wrap)
      .provideEnvironment(r)
    def getDocumentTextDetection(
        request: zio.aws.textract.model.GetDocumentTextDetectionRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
      zio.aws.textract.model.Block.ReadOnly
    ]] = asyncPaginatedRequest[
      GetDocumentTextDetectionRequest,
      GetDocumentTextDetectionResponse,
      Block
    ](
      "getDocumentTextDetection",
      api.getDocumentTextDetection,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.blocks().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.textract.model.GetDocumentTextDetectionResponse.wrap
          )
          .mapOutput(_.map(item => zio.aws.textract.model.Block.wrap(item)))
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def getDocumentTextDetectionPaginated(
        request: zio.aws.textract.model.GetDocumentTextDetectionRequest
    ): IO[
      AwsError,
      zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
    ] = asyncRequestResponse[
      GetDocumentTextDetectionRequest,
      GetDocumentTextDetectionResponse
    ]("getDocumentTextDetection", api.getDocumentTextDetection)(
      request.buildAwsValue()
    ).map(zio.aws.textract.model.GetDocumentTextDetectionResponse.wrap)
      .provideEnvironment(r)
  }
  def startExpenseAnalysis(
      request: zio.aws.textract.model.StartExpenseAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startExpenseAnalysis(request))
  def getDocumentAnalysis(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): ZIO[zio.aws.textract.Textract, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getDocumentAnalysis(request))
  def getDocumentAnalysisPaginated(
      request: zio.aws.textract.model.GetDocumentAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentAnalysisPaginated(request))
  def analyzeExpense(
      request: zio.aws.textract.model.AnalyzeExpenseRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.analyzeExpense(request))
  def detectDocumentText(
      request: zio.aws.textract.model.DetectDocumentTextRequest
  ): ZIO[zio.aws.textract.Textract, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.detectDocumentText(request))
  def startDocumentAnalysis(
      request: zio.aws.textract.model.StartDocumentAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDocumentAnalysis(request))
  def analyzeDocument(
      request: zio.aws.textract.model.AnalyzeDocumentRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.analyzeDocument(request))
  def getExpenseAnalysis(
      request: zio.aws.textract.model.GetExpenseAnalysisRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getExpenseAnalysis(request))
  def analyzeID(request: zio.aws.textract.model.AnalyzeIdRequest): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.AnalyzeIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.analyzeID(request))
  def startDocumentTextDetection(
      request: zio.aws.textract.model.StartDocumentTextDetectionRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDocumentTextDetection(request))
  def getDocumentTextDetection(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): ZIO[zio.aws.textract.Textract, AwsError, StreamingOutputResult[
    Any,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
    zio.aws.textract.model.Block.ReadOnly
  ]] = ZIO.serviceWithZIO(_.getDocumentTextDetection(request))
  def getDocumentTextDetectionPaginated(
      request: zio.aws.textract.model.GetDocumentTextDetectionRequest
  ): ZIO[
    zio.aws.textract.Textract,
    AwsError,
    zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getDocumentTextDetectionPaginated(request))
}
