package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.{StatusMessage, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class GetExpenseAnalysisResponse(
    documentMetadata: Option[zio.aws.textract.model.DocumentMetadata] = None,
    jobStatus: Option[zio.aws.textract.model.JobStatus] = None,
    nextToken: Option[PaginationToken] = None,
    expenseDocuments: Option[Iterable[zio.aws.textract.model.ExpenseDocument]] =
      None,
    warnings: Option[Iterable[zio.aws.textract.model.Warning]] = None,
    statusMessage: Option[StatusMessage] = None,
    analyzeExpenseModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse = {
    import GetExpenseAnalysisResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        expenseDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expenseDocuments)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        analyzeExpenseModelVersion.map(value => value: java.lang.String)
      )(_.analyzeExpenseModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly =
    zio.aws.textract.model.GetExpenseAnalysisResponse.wrap(buildAwsValue())
}
object GetExpenseAnalysisResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetExpenseAnalysisResponse =
      zio.aws.textract.model.GetExpenseAnalysisResponse(
        documentMetadata.map(value => value.asEditable),
        jobStatus.map(value => value),
        nextToken.map(value => value),
        expenseDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value),
        analyzeExpenseModelVersion.map(value => value)
      )
    def documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def jobStatus: Option[zio.aws.textract.model.JobStatus]
    def nextToken: Option[PaginationToken]
    def expenseDocuments
        : Option[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]]
    def warnings: Option[List[zio.aws.textract.model.Warning.ReadOnly]]
    def statusMessage: Option[StatusMessage]
    def analyzeExpenseModelVersion: Option[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.textract.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getExpenseDocuments: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("expenseDocuments", expenseDocuments)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getAnalyzeExpenseModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "analyzeExpenseModelVersion",
        analyzeExpenseModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
  ) extends zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly {
    override val documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly] = scala
      .Option(impl.documentMetadata())
      .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val jobStatus: Option[zio.aws.textract.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.textract.model.JobStatus.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
    override val expenseDocuments
        : Option[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]] = scala
      .Option(impl.expenseDocuments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.ExpenseDocument.wrap(item)
        }.toList
      )
    override val warnings
        : Option[List[zio.aws.textract.model.Warning.ReadOnly]] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.Warning.wrap(item)
        }.toList
      )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.textract.model.primitives.StatusMessage(value))
    override val analyzeExpenseModelVersion: Option[String] = scala
      .Option(impl.analyzeExpenseModelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetExpenseAnalysisResponse
  ): zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly = new Wrapper(
    impl
  )
}
