package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.{StatusMessage, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class GetDocumentTextDetectionResponse(
    documentMetadata: Option[zio.aws.textract.model.DocumentMetadata] = None,
    jobStatus: Option[zio.aws.textract.model.JobStatus] = None,
    nextToken: Option[PaginationToken] = None,
    blocks: Option[Iterable[zio.aws.textract.model.Block]] = None,
    warnings: Option[Iterable[zio.aws.textract.model.Warning]] = None,
    statusMessage: Option[StatusMessage] = None,
    detectDocumentTextModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse = {
    import GetDocumentTextDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        blocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocks)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        detectDocumentTextModelVersion.map(value => value: java.lang.String)
      )(_.detectDocumentTextModelVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly =
    zio.aws.textract.model.GetDocumentTextDetectionResponse
      .wrap(buildAwsValue())
}
object GetDocumentTextDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetDocumentTextDetectionResponse =
      zio.aws.textract.model.GetDocumentTextDetectionResponse(
        documentMetadata.map(value => value.asEditable),
        jobStatus.map(value => value),
        nextToken.map(value => value),
        blocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value),
        detectDocumentTextModelVersion.map(value => value)
      )
    def documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def jobStatus: Option[zio.aws.textract.model.JobStatus]
    def nextToken: Option[PaginationToken]
    def blocks: Option[List[zio.aws.textract.model.Block.ReadOnly]]
    def warnings: Option[List[zio.aws.textract.model.Warning.ReadOnly]]
    def statusMessage: Option[StatusMessage]
    def detectDocumentTextModelVersion: Option[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.textract.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBlocks
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Block.ReadOnly]] =
      AwsError.unwrapOptionField("blocks", blocks)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getDetectDocumentTextModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "detectDocumentTextModelVersion",
        detectDocumentTextModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
  ) extends zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly {
    override val documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly] = scala
      .Option(impl.documentMetadata())
      .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val jobStatus: Option[zio.aws.textract.model.JobStatus] = scala
      .Option(impl.jobStatus())
      .map(value => zio.aws.textract.model.JobStatus.wrap(value))
    override val nextToken: Option[PaginationToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
    override val blocks: Option[List[zio.aws.textract.model.Block.ReadOnly]] =
      scala
        .Option(impl.blocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Block.wrap(item)
          }.toList
        )
    override val warnings
        : Option[List[zio.aws.textract.model.Warning.ReadOnly]] = scala
      .Option(impl.warnings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.Warning.wrap(item)
        }.toList
      )
    override val statusMessage: Option[StatusMessage] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.textract.model.primitives.StatusMessage(value))
    override val detectDocumentTextModelVersion: Option[String] = scala
      .Option(impl.detectDocumentTextModelVersion())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
  ): zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly =
    new Wrapper(impl)
}
