package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.ImageBlob
import scala.jdk.CollectionConverters.*
final case class Document(
    bytes: Option[ImageBlob] = None,
    s3Object: Option[zio.aws.textract.model.S3Object] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.Document = {
    import Document.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Document
      .builder()
      .optionallyWith(
        bytes.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.bytes)
      .optionallyWith(s3Object.map(value => value.buildAwsValue()))(_.s3Object)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Document.ReadOnly =
    zio.aws.textract.model.Document.wrap(buildAwsValue())
}
object Document {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.textract.model.Document] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Document =
      zio.aws.textract.model.Document(
        bytes.map(value => value),
        s3Object.map(value => value.asEditable)
      )
    def bytes: Option[ImageBlob]
    def s3Object: Option[zio.aws.textract.model.S3Object.ReadOnly]
    def getBytes: ZIO[Any, AwsError, ImageBlob] =
      AwsError.unwrapOptionField("bytes", bytes)
    def getS3Object
        : ZIO[Any, AwsError, zio.aws.textract.model.S3Object.ReadOnly] =
      AwsError.unwrapOptionField("s3Object", s3Object)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Document
  ) extends zio.aws.textract.model.Document.ReadOnly {
    override val bytes: Option[ImageBlob] = scala
      .Option(impl.bytes())
      .map(value =>
        zio.aws.textract.model.primitives
          .ImageBlob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3Object: Option[zio.aws.textract.model.S3Object.ReadOnly] =
      scala
        .Option(impl.s3Object())
        .map(value => zio.aws.textract.model.S3Object.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Document
  ): zio.aws.textract.model.Document.ReadOnly = new Wrapper(impl)
}
