package zio.aws.textract.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.UInteger
import scala.jdk.CollectionConverters.*
final case class ExpenseField(
    `type`: Option[zio.aws.textract.model.ExpenseType] = None,
    labelDetection: Option[zio.aws.textract.model.ExpenseDetection] = None,
    valueDetection: Option[zio.aws.textract.model.ExpenseDetection] = None,
    pageNumber: Option[UInteger] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseField = {
    import ExpenseField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseField
      .builder()
      .optionallyWith(`type`.map(value => value.buildAwsValue()))(_.`type`)
      .optionallyWith(labelDetection.map(value => value.buildAwsValue()))(
        _.labelDetection
      )
      .optionallyWith(valueDetection.map(value => value.buildAwsValue()))(
        _.valueDetection
      )
      .optionallyWith(pageNumber.map(value => UInteger.unwrap(value): Integer))(
        _.pageNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseField.ReadOnly =
    zio.aws.textract.model.ExpenseField.wrap(buildAwsValue())
}
object ExpenseField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseField =
      zio.aws.textract.model.ExpenseField(
        `type`.map(value => value.asEditable),
        labelDetection.map(value => value.asEditable),
        valueDetection.map(value => value.asEditable),
        pageNumber.map(value => value)
      )
    def `type`: Option[zio.aws.textract.model.ExpenseType.ReadOnly]
    def labelDetection: Option[zio.aws.textract.model.ExpenseDetection.ReadOnly]
    def valueDetection: Option[zio.aws.textract.model.ExpenseDetection.ReadOnly]
    def pageNumber: Option[UInteger]
    def getType
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseType.ReadOnly] =
      AwsError.unwrapOptionField("type", `type`)
    def getLabelDetection
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      AwsError.unwrapOptionField("labelDetection", labelDetection)
    def getValueDetection
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      AwsError.unwrapOptionField("valueDetection", valueDetection)
    def getPageNumber: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseField
  ) extends zio.aws.textract.model.ExpenseField.ReadOnly {
    override val `type`: Option[zio.aws.textract.model.ExpenseType.ReadOnly] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.textract.model.ExpenseType.wrap(value))
    override val labelDetection
        : Option[zio.aws.textract.model.ExpenseDetection.ReadOnly] = scala
      .Option(impl.labelDetection())
      .map(value => zio.aws.textract.model.ExpenseDetection.wrap(value))
    override val valueDetection
        : Option[zio.aws.textract.model.ExpenseDetection.ReadOnly] = scala
      .Option(impl.valueDetection())
      .map(value => zio.aws.textract.model.ExpenseDetection.wrap(value))
    override val pageNumber: Option[UInteger] = scala
      .Option(impl.pageNumber())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseField
  ): zio.aws.textract.model.ExpenseField.ReadOnly = new Wrapper(impl)
}
