package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.{KMSKeyId, JobTag, ClientRequestToken}
import scala.jdk.CollectionConverters.*
final case class StartDocumentTextDetectionRequest(
    documentLocation: zio.aws.textract.model.DocumentLocation,
    clientRequestToken: Option[ClientRequestToken] = None,
    jobTag: Option[JobTag] = None,
    notificationChannel: Option[zio.aws.textract.model.NotificationChannel] =
      None,
    outputConfig: Option[zio.aws.textract.model.OutputConfig] = None,
    kmsKeyId: Option[KMSKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest = {
    import StartDocumentTextDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest
      .builder()
      .documentLocation(documentLocation.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.StartDocumentTextDetectionRequest.ReadOnly =
    zio.aws.textract.model.StartDocumentTextDetectionRequest
      .wrap(buildAwsValue())
}
object StartDocumentTextDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.StartDocumentTextDetectionRequest =
      zio.aws.textract.model.StartDocumentTextDetectionRequest(
        documentLocation.asEditable,
        clientRequestToken.map(value => value),
        jobTag.map(value => value),
        notificationChannel.map(value => value.asEditable),
        outputConfig.map(value => value.asEditable),
        kmsKeyId.map(value => value)
      )
    def documentLocation: zio.aws.textract.model.DocumentLocation.ReadOnly
    def clientRequestToken: Option[ClientRequestToken]
    def jobTag: Option[JobTag]
    def notificationChannel
        : Option[zio.aws.textract.model.NotificationChannel.ReadOnly]
    def outputConfig: Option[zio.aws.textract.model.OutputConfig.ReadOnly]
    def kmsKeyId: Option[KMSKeyId]
    def getDocumentLocation
        : ZIO[Any, Nothing, zio.aws.textract.model.DocumentLocation.ReadOnly] =
      ZIO.succeed(documentLocation)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getOutputConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.OutputConfig.ReadOnly] =
      AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest
  ) extends zio.aws.textract.model.StartDocumentTextDetectionRequest.ReadOnly {
    override val documentLocation
        : zio.aws.textract.model.DocumentLocation.ReadOnly =
      zio.aws.textract.model.DocumentLocation.wrap(impl.documentLocation())
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.textract.model.primitives.ClientRequestToken(value))
    override val jobTag: Option[JobTag] = scala
      .Option(impl.jobTag())
      .map(value => zio.aws.textract.model.primitives.JobTag(value))
    override val notificationChannel
        : Option[zio.aws.textract.model.NotificationChannel.ReadOnly] = scala
      .Option(impl.notificationChannel())
      .map(value => zio.aws.textract.model.NotificationChannel.wrap(value))
    override val outputConfig
        : Option[zio.aws.textract.model.OutputConfig.ReadOnly] = scala
      .Option(impl.outputConfig())
      .map(value => zio.aws.textract.model.OutputConfig.wrap(value))
    override val kmsKeyId: Option[KMSKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.textract.model.primitives.KMSKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentTextDetectionRequest
  ): zio.aws.textract.model.StartDocumentTextDetectionRequest.ReadOnly =
    new Wrapper(impl)
}
