package zio.aws.textract.model
import scala.jdk.CollectionConverters.*
sealed trait TextType {
  def unwrap: software.amazon.awssdk.services.textract.model.TextType
}
object TextType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.TextType
  ): zio.aws.textract.model.TextType = value match {
    case software.amazon.awssdk.services.textract.model.TextType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.TextType.HANDWRITING =>
      val r = HANDWRITING
      r
    case software.amazon.awssdk.services.textract.model.TextType.PRINTED =>
      val r = PRINTED
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.TextType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.TextType =
      software.amazon.awssdk.services.textract.model.TextType.UNKNOWN_TO_SDK_VERSION
  }
  case object HANDWRITING extends zio.aws.textract.model.TextType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.TextType =
      software.amazon.awssdk.services.textract.model.TextType.HANDWRITING
  }
  case object PRINTED extends zio.aws.textract.model.TextType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.TextType =
      software.amazon.awssdk.services.textract.model.TextType.PRINTED
  }
}
