package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.{KMSKeyId, JobTag, ClientRequestToken}
import scala.jdk.CollectionConverters.*
final case class StartDocumentAnalysisRequest(
    documentLocation: zio.aws.textract.model.DocumentLocation,
    featureTypes: Iterable[zio.aws.textract.model.FeatureType],
    clientRequestToken: Option[ClientRequestToken] = None,
    jobTag: Option[JobTag] = None,
    notificationChannel: Option[zio.aws.textract.model.NotificationChannel] =
      None,
    outputConfig: Option[zio.aws.textract.model.OutputConfig] = None,
    kmsKeyId: Option[KMSKeyId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest = {
    import StartDocumentAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
      .builder()
      .documentLocation(documentLocation.buildAwsValue())
      .featureTypesWithStrings(featureTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.StartDocumentAnalysisRequest.ReadOnly =
    zio.aws.textract.model.StartDocumentAnalysisRequest.wrap(buildAwsValue())
}
object StartDocumentAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.StartDocumentAnalysisRequest =
      zio.aws.textract.model.StartDocumentAnalysisRequest(
        documentLocation.asEditable,
        featureTypes,
        clientRequestToken.map(value => value),
        jobTag.map(value => value),
        notificationChannel.map(value => value.asEditable),
        outputConfig.map(value => value.asEditable),
        kmsKeyId.map(value => value)
      )
    def documentLocation: zio.aws.textract.model.DocumentLocation.ReadOnly
    def featureTypes: List[zio.aws.textract.model.FeatureType]
    def clientRequestToken: Option[ClientRequestToken]
    def jobTag: Option[JobTag]
    def notificationChannel
        : Option[zio.aws.textract.model.NotificationChannel.ReadOnly]
    def outputConfig: Option[zio.aws.textract.model.OutputConfig.ReadOnly]
    def kmsKeyId: Option[KMSKeyId]
    def getDocumentLocation
        : ZIO[Any, Nothing, zio.aws.textract.model.DocumentLocation.ReadOnly] =
      ZIO.succeed(documentLocation)
    def getFeatureTypes
        : ZIO[Any, Nothing, List[zio.aws.textract.model.FeatureType]] =
      ZIO.succeed(featureTypes)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getOutputConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.OutputConfig.ReadOnly] =
      AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
  ) extends zio.aws.textract.model.StartDocumentAnalysisRequest.ReadOnly {
    override val documentLocation
        : zio.aws.textract.model.DocumentLocation.ReadOnly =
      zio.aws.textract.model.DocumentLocation.wrap(impl.documentLocation())
    override val featureTypes: List[zio.aws.textract.model.FeatureType] = impl
      .featureTypes()
      .asScala
      .map { item =>
        zio.aws.textract.model.FeatureType.wrap(item)
      }
      .toList
    override val clientRequestToken: Option[ClientRequestToken] = scala
      .Option(impl.clientRequestToken())
      .map(value => zio.aws.textract.model.primitives.ClientRequestToken(value))
    override val jobTag: Option[JobTag] = scala
      .Option(impl.jobTag())
      .map(value => zio.aws.textract.model.primitives.JobTag(value))
    override val notificationChannel
        : Option[zio.aws.textract.model.NotificationChannel.ReadOnly] = scala
      .Option(impl.notificationChannel())
      .map(value => zio.aws.textract.model.NotificationChannel.wrap(value))
    override val outputConfig
        : Option[zio.aws.textract.model.OutputConfig.ReadOnly] = scala
      .Option(impl.outputConfig())
      .map(value => zio.aws.textract.model.OutputConfig.wrap(value))
    override val kmsKeyId: Option[KMSKeyId] = scala
      .Option(impl.kmsKeyId())
      .map(value => zio.aws.textract.model.primitives.KMSKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.StartDocumentAnalysisRequest
  ): zio.aws.textract.model.StartDocumentAnalysisRequest.ReadOnly = new Wrapper(
    impl
  )
}
