package zio.aws.textract
import zio.aws.textract.model.DetectDocumentTextResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.textract.TextractAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
import zio.aws.textract.model.{
  ListAdaptersRequest,
  StartDocumentTextDetectionRequest,
  GetDocumentAnalysisRequest,
  AnalyzeExpenseRequest,
  GetDocumentTextDetectionRequest,
  GetAdapterVersionRequest,
  GetLendingAnalysisSummaryRequest,
  AnalyzeIdRequest,
  GetLendingAnalysisRequest,
  StartLendingAnalysisRequest,
  ListTagsForResourceRequest,
  UpdateAdapterRequest,
  ListAdapterVersionsRequest,
  CreateAdapterRequest,
  CreateAdapterVersionRequest,
  DeleteAdapterVersionRequest,
  StartDocumentAnalysisRequest,
  DetectDocumentTextRequest,
  DeleteAdapterRequest,
  GetAdapterRequest,
  AnalyzeDocumentRequest,
  GetExpenseAnalysisRequest,
  UntagResourceRequest,
  StartExpenseAnalysisRequest,
  TagResourceRequest
}
object TextractMock extends Mock[Textract] {
  object DeleteAdapter
      extends Effect[
        DeleteAdapterRequest,
        AwsError,
        zio.aws.textract.model.DeleteAdapterResponse.ReadOnly
      ]
  object StartExpenseAnalysis
      extends Effect[
        StartExpenseAnalysisRequest,
        AwsError,
        zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
      ]
  object GetDocumentAnalysis
      extends Effect[
        GetDocumentAnalysisRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
          zio.aws.textract.model.Block.ReadOnly
        ]
      ]
  object GetDocumentAnalysisPaginated
      extends Effect[
        GetDocumentAnalysisRequest,
        AwsError,
        zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
      ]
  object UpdateAdapter
      extends Effect[
        UpdateAdapterRequest,
        AwsError,
        zio.aws.textract.model.UpdateAdapterResponse.ReadOnly
      ]
  object GetLendingAnalysisSummary
      extends Effect[
        GetLendingAnalysisSummaryRequest,
        AwsError,
        zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly
      ]
  object AnalyzeExpense
      extends Effect[
        AnalyzeExpenseRequest,
        AwsError,
        zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly
      ]
  object CreateAdapter
      extends Effect[
        CreateAdapterRequest,
        AwsError,
        zio.aws.textract.model.CreateAdapterResponse.ReadOnly
      ]
  object StartLendingAnalysis
      extends Effect[
        StartLendingAnalysisRequest,
        AwsError,
        zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly
      ]
  object GetAdapter
      extends Effect[
        GetAdapterRequest,
        AwsError,
        zio.aws.textract.model.GetAdapterResponse.ReadOnly
      ]
  object DetectDocumentText
      extends Effect[DetectDocumentTextRequest, AwsError, ReadOnly]
  object StartDocumentAnalysis
      extends Effect[
        StartDocumentAnalysisRequest,
        AwsError,
        zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
      ]
  object AnalyzeDocument
      extends Effect[
        AnalyzeDocumentRequest,
        AwsError,
        zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly
      ]
  object GetExpenseAnalysis
      extends Effect[
        GetExpenseAnalysisRequest,
        AwsError,
        zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
      ]
  object CreateAdapterVersion
      extends Effect[
        CreateAdapterVersionRequest,
        AwsError,
        zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly
      ]
  object ListAdapterVersions
      extends Stream[
        ListAdapterVersionsRequest,
        AwsError,
        zio.aws.textract.model.AdapterVersionOverview.ReadOnly
      ]
  object ListAdapterVersionsPaginated
      extends Effect[
        ListAdapterVersionsRequest,
        AwsError,
        zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.textract.model.UntagResourceResponse.ReadOnly
      ]
  object AnalyzeID
      extends Effect[
        AnalyzeIdRequest,
        AwsError,
        zio.aws.textract.model.AnalyzeIdResponse.ReadOnly
      ]
  object GetLendingAnalysis
      extends Effect[
        GetLendingAnalysisRequest,
        AwsError,
        zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.textract.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.textract.model.TagResourceResponse.ReadOnly
      ]
  object GetAdapterVersion
      extends Effect[
        GetAdapterVersionRequest,
        AwsError,
        zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly
      ]
  object StartDocumentTextDetection
      extends Effect[
        StartDocumentTextDetectionRequest,
        AwsError,
        zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
      ]
  object GetDocumentTextDetection
      extends Effect[
        GetDocumentTextDetectionRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
          zio.aws.textract.model.Block.ReadOnly
        ]
      ]
  object GetDocumentTextDetectionPaginated
      extends Effect[
        GetDocumentTextDetectionRequest,
        AwsError,
        zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
      ]
  object DeleteAdapterVersion
      extends Effect[
        DeleteAdapterVersionRequest,
        AwsError,
        zio.aws.textract.model.DeleteAdapterVersionResponse.ReadOnly
      ]
  object ListAdapters
      extends Stream[
        ListAdaptersRequest,
        AwsError,
        zio.aws.textract.model.AdapterOverview.ReadOnly
      ]
  object ListAdaptersPaginated
      extends Effect[
        ListAdaptersRequest,
        AwsError,
        zio.aws.textract.model.ListAdaptersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Textract] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Textract] { rts =>
        ZIO.succeed {
          new Textract {
            val api: TextractAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Textract = this
            def deleteAdapter(request: DeleteAdapterRequest): IO[
              AwsError,
              zio.aws.textract.model.DeleteAdapterResponse.ReadOnly
            ] = proxy(DeleteAdapter, request)
            def startExpenseAnalysis(request: StartExpenseAnalysisRequest): IO[
              AwsError,
              zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
            ] = proxy(StartExpenseAnalysis, request)
            def getDocumentAnalysis(
                request: GetDocumentAnalysisRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
              zio.aws.textract.model.Block.ReadOnly
            ]] = proxy(GetDocumentAnalysis, request)
            def getDocumentAnalysisPaginated(
                request: GetDocumentAnalysisRequest
            ): IO[
              AwsError,
              zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
            ] = proxy(GetDocumentAnalysisPaginated, request)
            def updateAdapter(request: UpdateAdapterRequest): IO[
              AwsError,
              zio.aws.textract.model.UpdateAdapterResponse.ReadOnly
            ] = proxy(UpdateAdapter, request)
            def getLendingAnalysisSummary(
                request: GetLendingAnalysisSummaryRequest
            ): IO[
              AwsError,
              zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly
            ] = proxy(GetLendingAnalysisSummary, request)
            def analyzeExpense(request: AnalyzeExpenseRequest): IO[
              AwsError,
              zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly
            ] = proxy(AnalyzeExpense, request)
            def createAdapter(request: CreateAdapterRequest): IO[
              AwsError,
              zio.aws.textract.model.CreateAdapterResponse.ReadOnly
            ] = proxy(CreateAdapter, request)
            def startLendingAnalysis(request: StartLendingAnalysisRequest): IO[
              AwsError,
              zio.aws.textract.model.StartLendingAnalysisResponse.ReadOnly
            ] = proxy(StartLendingAnalysis, request)
            def getAdapter(request: GetAdapterRequest): IO[
              AwsError,
              zio.aws.textract.model.GetAdapterResponse.ReadOnly
            ] = proxy(GetAdapter, request)
            def detectDocumentText(
                request: DetectDocumentTextRequest
            ): IO[AwsError, ReadOnly] = proxy(DetectDocumentText, request)
            def startDocumentAnalysis(
                request: StartDocumentAnalysisRequest
            ): IO[
              AwsError,
              zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
            ] = proxy(StartDocumentAnalysis, request)
            def analyzeDocument(request: AnalyzeDocumentRequest): IO[
              AwsError,
              zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly
            ] = proxy(AnalyzeDocument, request)
            def getExpenseAnalysis(request: GetExpenseAnalysisRequest): IO[
              AwsError,
              zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
            ] = proxy(GetExpenseAnalysis, request)
            def createAdapterVersion(request: CreateAdapterVersionRequest): IO[
              AwsError,
              zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly
            ] = proxy(CreateAdapterVersion, request)
            def listAdapterVersions(
                request: ListAdapterVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.textract.model.AdapterVersionOverview.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAdapterVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAdapterVersionsPaginated(
                request: ListAdapterVersionsRequest
            ): IO[
              AwsError,
              zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly
            ] = proxy(ListAdapterVersionsPaginated, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.textract.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def analyzeID(
                request: AnalyzeIdRequest
            ): IO[AwsError, zio.aws.textract.model.AnalyzeIdResponse.ReadOnly] =
              proxy(AnalyzeID, request)
            def getLendingAnalysis(request: GetLendingAnalysisRequest): IO[
              AwsError,
              zio.aws.textract.model.GetLendingAnalysisResponse.ReadOnly
            ] = proxy(GetLendingAnalysis, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.textract.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.textract.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def getAdapterVersion(request: GetAdapterVersionRequest): IO[
              AwsError,
              zio.aws.textract.model.GetAdapterVersionResponse.ReadOnly
            ] = proxy(GetAdapterVersion, request)
            def startDocumentTextDetection(
                request: StartDocumentTextDetectionRequest
            ): IO[
              AwsError,
              zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
            ] = proxy(StartDocumentTextDetection, request)
            def getDocumentTextDetection(
                request: GetDocumentTextDetectionRequest
            ): ZIO[Any, AwsError, StreamingOutputResult[
              Any,
              zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
              zio.aws.textract.model.Block.ReadOnly
            ]] = proxy(GetDocumentTextDetection, request)
            def getDocumentTextDetectionPaginated(
                request: GetDocumentTextDetectionRequest
            ): IO[
              AwsError,
              zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
            ] = proxy(GetDocumentTextDetectionPaginated, request)
            def deleteAdapterVersion(request: DeleteAdapterVersionRequest): IO[
              AwsError,
              zio.aws.textract.model.DeleteAdapterVersionResponse.ReadOnly
            ] = proxy(DeleteAdapterVersion, request)
            def listAdapters(request: ListAdaptersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.textract.model.AdapterOverview.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAdapters, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAdaptersPaginated(request: ListAdaptersRequest): IO[
              AwsError,
              zio.aws.textract.model.ListAdaptersResponse.ReadOnly
            ] = proxy(ListAdaptersPaginated, request)
          }
        }
      }
    }
  }
}
