package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.NonEmptyString
import scala.jdk.CollectionConverters._
final case class LendingSummary(
    documentGroups: Optional[Iterable[zio.aws.textract.model.DocumentGroup]] =
      Optional.Absent,
    undetectedDocumentTypes: Optional[Iterable[NonEmptyString]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.LendingSummary = {
    import LendingSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.LendingSummary
      .builder()
      .optionallyWith(
        documentGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentGroups)
      .optionallyWith(
        undetectedDocumentTypes.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.undetectedDocumentTypes)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.LendingSummary.ReadOnly =
    zio.aws.textract.model.LendingSummary.wrap(buildAwsValue())
}
object LendingSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.LendingSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.LendingSummary =
      zio.aws.textract.model.LendingSummary(
        documentGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        undetectedDocumentTypes.map(value => value)
      )
    def documentGroups
        : Optional[List[zio.aws.textract.model.DocumentGroup.ReadOnly]]
    def undetectedDocumentTypes: Optional[List[NonEmptyString]]
    def getDocumentGroups: ZIO[Any, AwsError, List[
      zio.aws.textract.model.DocumentGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("documentGroups", documentGroups)
    def getUndetectedDocumentTypes: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField(
        "undetectedDocumentTypes",
        undetectedDocumentTypes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.LendingSummary
  ) extends zio.aws.textract.model.LendingSummary.ReadOnly {
    override val documentGroups
        : Optional[List[zio.aws.textract.model.DocumentGroup.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.DocumentGroup.wrap(item)
          }.toList
        )
    override val undetectedDocumentTypes: Optional[List[NonEmptyString]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.undetectedDocumentTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.primitives.NonEmptyString(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.LendingSummary
  ): zio.aws.textract.model.LendingSummary.ReadOnly = new Wrapper(impl)
}
