package zio.aws.textract.model
import scala.jdk.CollectionConverters._
sealed trait EntityType {
  def unwrap: software.amazon.awssdk.services.textract.model.EntityType
}
object EntityType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.EntityType
  ): zio.aws.textract.model.EntityType = value match {
    case software.amazon.awssdk.services.textract.model.EntityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.EntityType.KEY =>
      val r = KEY
      r
    case software.amazon.awssdk.services.textract.model.EntityType.VALUE =>
      val r = VALUE
      r
    case software.amazon.awssdk.services.textract.model.EntityType.COLUMN_HEADER =>
      val r = COLUMN_HEADER
      r
    case software.amazon.awssdk.services.textract.model.EntityType.TABLE_TITLE =>
      val r = TABLE_TITLE
      r
    case software.amazon.awssdk.services.textract.model.EntityType.TABLE_FOOTER =>
      val r = TABLE_FOOTER
      r
    case software.amazon.awssdk.services.textract.model.EntityType.TABLE_SECTION_TITLE =>
      val r = TABLE_SECTION_TITLE
      r
    case software.amazon.awssdk.services.textract.model.EntityType.TABLE_SUMMARY =>
      val r = TABLE_SUMMARY
      r
    case software.amazon.awssdk.services.textract.model.EntityType.STRUCTURED_TABLE =>
      val r = STRUCTURED_TABLE
      r
    case software.amazon.awssdk.services.textract.model.EntityType.SEMI_STRUCTURED_TABLE =>
      val r = SEMI_STRUCTURED_TABLE
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.UNKNOWN_TO_SDK_VERSION
  }
  case object KEY extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.KEY
  }
  case object VALUE extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.VALUE
  }
  case object COLUMN_HEADER extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.COLUMN_HEADER
  }
  case object TABLE_TITLE extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.TABLE_TITLE
  }
  case object TABLE_FOOTER extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.TABLE_FOOTER
  }
  case object TABLE_SECTION_TITLE extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.TABLE_SECTION_TITLE
  }
  case object TABLE_SUMMARY extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.TABLE_SUMMARY
  }
  case object STRUCTURED_TABLE extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.STRUCTURED_TABLE
  }
  case object SEMI_STRUCTURED_TABLE extends zio.aws.textract.model.EntityType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.EntityType =
      software.amazon.awssdk.services.textract.model.EntityType.SEMI_STRUCTURED_TABLE
  }
}
