package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.textract.model.primitives.{TagKey, AmazonResourceName}
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceARN: AmazonResourceName,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.UntagResourceRequest
      .builder()
      .resourceARN(AmazonResourceName.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.UntagResourceRequest.ReadOnly =
    zio.aws.textract.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.UntagResourceRequest =
      zio.aws.textract.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: AmazonResourceName
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.UntagResourceRequest
  ) extends zio.aws.textract.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: AmazonResourceName =
      zio.aws.textract.model.primitives.AmazonResourceName(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.textract.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.UntagResourceRequest
  ): zio.aws.textract.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
