package zio.aws.textract.model
import zio.aws.textract.model.primitives.{PaginationToken, MaxResults, DateTime}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAdaptersRequest(
    afterCreationTime: Optional[DateTime] = Optional.Absent,
    beforeCreationTime: Optional[DateTime] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ListAdaptersRequest = {
    import ListAdaptersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ListAdaptersRequest
      .builder()
      .optionallyWith(
        afterCreationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.afterCreationTime)
      .optionallyWith(
        beforeCreationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.beforeCreationTime)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ListAdaptersRequest.ReadOnly =
    zio.aws.textract.model.ListAdaptersRequest.wrap(buildAwsValue())
}
object ListAdaptersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ListAdaptersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ListAdaptersRequest =
      zio.aws.textract.model.ListAdaptersRequest(
        afterCreationTime.map(value => value),
        beforeCreationTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def afterCreationTime: Optional[DateTime]
    def beforeCreationTime: Optional[DateTime]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getAfterCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("afterCreationTime", afterCreationTime)
    def getBeforeCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("beforeCreationTime", beforeCreationTime)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ListAdaptersRequest
  ) extends zio.aws.textract.model.ListAdaptersRequest.ReadOnly {
    override val afterCreationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.afterCreationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val beforeCreationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeCreationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.textract.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ListAdaptersRequest
  ): zio.aws.textract.model.ListAdaptersRequest.ReadOnly = new Wrapper(impl)
}
