package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{AdapterVersion, AdapterId}
import scala.jdk.CollectionConverters._
final case class CreateAdapterVersionResponse(
    adapterId: Optional[AdapterId] = Optional.Absent,
    adapterVersion: Optional[AdapterVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse = {
    import CreateAdapterVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .optionallyWith(
        adapterVersion.map(value =>
          AdapterVersion.unwrap(value): java.lang.String
        )
      )(_.adapterVersion)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly =
    zio.aws.textract.model.CreateAdapterVersionResponse.wrap(buildAwsValue())
}
object CreateAdapterVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.CreateAdapterVersionResponse =
      zio.aws.textract.model.CreateAdapterVersionResponse(
        adapterId.map(value => value),
        adapterVersion.map(value => value)
      )
    def adapterId: Optional[AdapterId]
    def adapterVersion: Optional[AdapterVersion]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
    def getAdapterVersion: ZIO[Any, AwsError, AdapterVersion] =
      AwsError.unwrapOptionField("adapterVersion", adapterVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse
  ) extends zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
    override val adapterVersion: Optional[AdapterVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.adapterVersion())
        .map(value => zio.aws.textract.model.primitives.AdapterVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterVersionResponse
  ): zio.aws.textract.model.CreateAdapterVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
