package zio.aws.textract.model
import scala.jdk.CollectionConverters._
sealed trait AutoUpdate {
  def unwrap: software.amazon.awssdk.services.textract.model.AutoUpdate
}
object AutoUpdate {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.AutoUpdate
  ): zio.aws.textract.model.AutoUpdate = value match {
    case software.amazon.awssdk.services.textract.model.AutoUpdate.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.AutoUpdate.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.textract.model.AutoUpdate.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.textract.model.AutoUpdate {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AutoUpdate =
      software.amazon.awssdk.services.textract.model.AutoUpdate.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.textract.model.AutoUpdate {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AutoUpdate =
      software.amazon.awssdk.services.textract.model.AutoUpdate.ENABLED
  }
  case object DISABLED extends zio.aws.textract.model.AutoUpdate {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AutoUpdate =
      software.amazon.awssdk.services.textract.model.AutoUpdate.DISABLED
  }
}
