package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.textract.model.primitives.AdapterId
import scala.jdk.CollectionConverters._
final case class GetAdapterRequest(adapterId: AdapterId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetAdapterRequest = {
    import GetAdapterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetAdapterRequest
      .builder()
      .adapterId(AdapterId.unwrap(adapterId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.GetAdapterRequest.ReadOnly =
    zio.aws.textract.model.GetAdapterRequest.wrap(buildAwsValue())
}
object GetAdapterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetAdapterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetAdapterRequest =
      zio.aws.textract.model.GetAdapterRequest(adapterId)
    def adapterId: AdapterId
    def getAdapterId: ZIO[Any, Nothing, AdapterId] = ZIO.succeed(adapterId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterRequest
  ) extends zio.aws.textract.model.GetAdapterRequest.ReadOnly {
    override val adapterId: AdapterId =
      zio.aws.textract.model.primitives.AdapterId(impl.adapterId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterRequest
  ): zio.aws.textract.model.GetAdapterRequest.ReadOnly = new Wrapper(impl)
}
