package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{
  AdapterName,
  ClientRequestToken,
  TagValue,
  AdapterDescription,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateAdapterRequest(
    adapterName: AdapterName,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    description: Optional[AdapterDescription] = Optional.Absent,
    featureTypes: Iterable[zio.aws.textract.model.FeatureType],
    autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.CreateAdapterRequest = {
    import CreateAdapterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.CreateAdapterRequest
      .builder()
      .adapterName(AdapterName.unwrap(adapterName): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        description.map(value =>
          AdapterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .featureTypesWithStrings(featureTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(autoUpdate.map(value => value.unwrap))(_.autoUpdate)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.CreateAdapterRequest.ReadOnly =
    zio.aws.textract.model.CreateAdapterRequest.wrap(buildAwsValue())
}
object CreateAdapterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.CreateAdapterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.CreateAdapterRequest =
      zio.aws.textract.model.CreateAdapterRequest(
        adapterName,
        clientRequestToken.map(value => value),
        description.map(value => value),
        featureTypes,
        autoUpdate.map(value => value),
        tags.map(value => value)
      )
    def adapterName: AdapterName
    def clientRequestToken: Optional[ClientRequestToken]
    def description: Optional[AdapterDescription]
    def featureTypes: List[zio.aws.textract.model.FeatureType]
    def autoUpdate: Optional[zio.aws.textract.model.AutoUpdate]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAdapterName: ZIO[Any, Nothing, AdapterName] =
      ZIO.succeed(adapterName)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDescription: ZIO[Any, AwsError, AdapterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFeatureTypes
        : ZIO[Any, Nothing, List[zio.aws.textract.model.FeatureType]] =
      ZIO.succeed(featureTypes)
    def getAutoUpdate: ZIO[Any, AwsError, zio.aws.textract.model.AutoUpdate] =
      AwsError.unwrapOptionField("autoUpdate", autoUpdate)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterRequest
  ) extends zio.aws.textract.model.CreateAdapterRequest.ReadOnly {
    override val adapterName: AdapterName =
      zio.aws.textract.model.primitives.AdapterName(impl.adapterName())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.textract.model.primitives.ClientRequestToken(value)
        )
    override val description: Optional[AdapterDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.textract.model.primitives.AdapterDescription(value)
        )
    override val featureTypes: List[zio.aws.textract.model.FeatureType] = impl
      .featureTypes()
      .asScala
      .map { item =>
        zio.aws.textract.model.FeatureType.wrap(item)
      }
      .toList
    override val autoUpdate: Optional[zio.aws.textract.model.AutoUpdate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoUpdate())
        .map(value => zio.aws.textract.model.AutoUpdate.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.textract.model.primitives
              .TagKey(key) -> zio.aws.textract.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterRequest
  ): zio.aws.textract.model.CreateAdapterRequest.ReadOnly = new Wrapper(impl)
}
