package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PageClassification(
    pageType: Iterable[zio.aws.textract.model.Prediction],
    pageNumber: Iterable[zio.aws.textract.model.Prediction]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.PageClassification = {
    import PageClassification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.PageClassification
      .builder()
      .pageType(pageType.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .pageNumber(pageNumber.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.PageClassification.ReadOnly =
    zio.aws.textract.model.PageClassification.wrap(buildAwsValue())
}
object PageClassification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.PageClassification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.PageClassification =
      zio.aws.textract.model.PageClassification(
        pageType.map { item =>
          item.asEditable
        },
        pageNumber.map { item =>
          item.asEditable
        }
      )
    def pageType: List[zio.aws.textract.model.Prediction.ReadOnly]
    def pageNumber: List[zio.aws.textract.model.Prediction.ReadOnly]
    def getPageType
        : ZIO[Any, Nothing, List[zio.aws.textract.model.Prediction.ReadOnly]] =
      ZIO.succeed(pageType)
    def getPageNumber
        : ZIO[Any, Nothing, List[zio.aws.textract.model.Prediction.ReadOnly]] =
      ZIO.succeed(pageNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.PageClassification
  ) extends zio.aws.textract.model.PageClassification.ReadOnly {
    override val pageType: List[zio.aws.textract.model.Prediction.ReadOnly] =
      impl
        .pageType()
        .asScala
        .map { item =>
          zio.aws.textract.model.Prediction.wrap(item)
        }
        .toList
    override val pageNumber: List[zio.aws.textract.model.Prediction.ReadOnly] =
      impl
        .pageNumber()
        .asScala
        .map { item =>
          zio.aws.textract.model.Prediction.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.PageClassification
  ): zio.aws.textract.model.PageClassification.ReadOnly = new Wrapper(impl)
}
