package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ExpenseField(
    `type`: Optional[zio.aws.textract.model.ExpenseType] = Optional.Absent,
    labelDetection: Optional[zio.aws.textract.model.ExpenseDetection] =
      Optional.Absent,
    valueDetection: Optional[zio.aws.textract.model.ExpenseDetection] =
      Optional.Absent,
    pageNumber: Optional[UInteger] = Optional.Absent,
    currency: Optional[zio.aws.textract.model.ExpenseCurrency] =
      Optional.Absent,
    groupProperties: Optional[
      Iterable[zio.aws.textract.model.ExpenseGroupProperty]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseField = {
    import ExpenseField.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseField
      .builder()
      .optionallyWith(`type`.map(value => value.buildAwsValue()))(_.`type`)
      .optionallyWith(labelDetection.map(value => value.buildAwsValue()))(
        _.labelDetection
      )
      .optionallyWith(valueDetection.map(value => value.buildAwsValue()))(
        _.valueDetection
      )
      .optionallyWith(pageNumber.map(value => UInteger.unwrap(value): Integer))(
        _.pageNumber
      )
      .optionallyWith(currency.map(value => value.buildAwsValue()))(_.currency)
      .optionallyWith(
        groupProperties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupProperties)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseField.ReadOnly =
    zio.aws.textract.model.ExpenseField.wrap(buildAwsValue())
}
object ExpenseField {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseField
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseField =
      zio.aws.textract.model.ExpenseField(
        `type`.map(value => value.asEditable),
        labelDetection.map(value => value.asEditable),
        valueDetection.map(value => value.asEditable),
        pageNumber.map(value => value),
        currency.map(value => value.asEditable),
        groupProperties.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def `type`: Optional[zio.aws.textract.model.ExpenseType.ReadOnly]
    def labelDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly]
    def valueDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly]
    def pageNumber: Optional[UInteger]
    def currency: Optional[zio.aws.textract.model.ExpenseCurrency.ReadOnly]
    def groupProperties
        : Optional[List[zio.aws.textract.model.ExpenseGroupProperty.ReadOnly]]
    def getType
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseType.ReadOnly] =
      AwsError.unwrapOptionField("type", `type`)
    def getLabelDetection
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      AwsError.unwrapOptionField("labelDetection", labelDetection)
    def getValueDetection
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      AwsError.unwrapOptionField("valueDetection", valueDetection)
    def getPageNumber: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("pageNumber", pageNumber)
    def getCurrency
        : ZIO[Any, AwsError, zio.aws.textract.model.ExpenseCurrency.ReadOnly] =
      AwsError.unwrapOptionField("currency", currency)
    def getGroupProperties: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseGroupProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("groupProperties", groupProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseField
  ) extends zio.aws.textract.model.ExpenseField.ReadOnly {
    override val `type`: Optional[zio.aws.textract.model.ExpenseType.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.textract.model.ExpenseType.wrap(value))
    override val labelDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.labelDetection())
        .map(value => zio.aws.textract.model.ExpenseDetection.wrap(value))
    override val valueDetection
        : Optional[zio.aws.textract.model.ExpenseDetection.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueDetection())
        .map(value => zio.aws.textract.model.ExpenseDetection.wrap(value))
    override val pageNumber: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.pageNumber())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val currency
        : Optional[zio.aws.textract.model.ExpenseCurrency.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currency())
        .map(value => zio.aws.textract.model.ExpenseCurrency.wrap(value))
    override val groupProperties
        : Optional[List[zio.aws.textract.model.ExpenseGroupProperty.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.groupProperties())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.ExpenseGroupProperty.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseField
  ): zio.aws.textract.model.ExpenseField.ReadOnly = new Wrapper(impl)
}
