package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ExpenseGroupProperty(
    types: Optional[Iterable[String]] = Optional.Absent,
    id: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseGroupProperty = {
    import ExpenseGroupProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseGroupProperty
      .builder()
      .optionallyWith(
        types.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.types)
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseGroupProperty.ReadOnly =
    zio.aws.textract.model.ExpenseGroupProperty.wrap(buildAwsValue())
}
object ExpenseGroupProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseGroupProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseGroupProperty =
      zio.aws.textract.model
        .ExpenseGroupProperty(types.map(value => value), id.map(value => value))
    def types: Optional[List[String]]
    def id: Optional[String]
    def getTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("types", types)
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseGroupProperty
  ) extends zio.aws.textract.model.ExpenseGroupProperty.ReadOnly {
    override val types: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.types())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseGroupProperty
  ): zio.aws.textract.model.ExpenseGroupProperty.ReadOnly = new Wrapper(impl)
}
