package zio.aws.textract
import zio.prelude.Subtype
import zio.Chunk
import zio.aws.textract.model.primitives.{
  QueryPage,
  UInteger,
  NonEmptyString,
  HumanLoopActivationReason
}
import zio.aws.textract.model.primitives.ErrorCode.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ClientRequestToken extends Subtype[String]
    type ClientRequestToken =
      zio.aws.textract.model.primitives.ClientRequestToken.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.textract.model.primitives.ErrorCode.Type
    object FlowDefinitionArn extends Subtype[String]
    type FlowDefinitionArn =
      zio.aws.textract.model.primitives.FlowDefinitionArn.Type
    object HumanLoopActivationConditionsEvaluationResults
        extends Subtype[String]
    type HumanLoopActivationConditionsEvaluationResults =
      zio.aws.textract.model.primitives.HumanLoopActivationConditionsEvaluationResults.Type
    object HumanLoopActivationReason extends Subtype[String]
    type HumanLoopActivationReason =
      zio.aws.textract.model.primitives.HumanLoopActivationReason.Type
    object HumanLoopArn extends Subtype[String]
    type HumanLoopArn = zio.aws.textract.model.primitives.HumanLoopArn.Type
    object HumanLoopName extends Subtype[String]
    type HumanLoopName = zio.aws.textract.model.primitives.HumanLoopName.Type
    object ImageBlob extends Subtype[Chunk[Byte]]
    type ImageBlob = zio.aws.textract.model.primitives.ImageBlob.Type
    object JobId extends Subtype[String]
    type JobId = zio.aws.textract.model.primitives.JobId.Type
    object JobTag extends Subtype[String]
    type JobTag = zio.aws.textract.model.primitives.JobTag.Type
    object KMSKeyId extends Subtype[String]
    type KMSKeyId = zio.aws.textract.model.primitives.KMSKeyId.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.textract.model.primitives.MaxResults.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString = zio.aws.textract.model.primitives.NonEmptyString.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.textract.model.primitives.PaginationToken.Type
    object Percent extends Subtype[Float]
    type Percent = zio.aws.textract.model.primitives.Percent.Type
    object QueryInput extends Subtype[String]
    type QueryInput = zio.aws.textract.model.primitives.QueryInput.Type
    object QueryPage extends Subtype[String]
    type QueryPage = zio.aws.textract.model.primitives.QueryPage.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.textract.model.primitives.RoleArn.Type
    object S3Bucket extends Subtype[String]
    type S3Bucket = zio.aws.textract.model.primitives.S3Bucket.Type
    object S3ObjectName extends Subtype[String]
    type S3ObjectName = zio.aws.textract.model.primitives.S3ObjectName.Type
    object S3ObjectVersion extends Subtype[String]
    type S3ObjectVersion =
      zio.aws.textract.model.primitives.S3ObjectVersion.Type
    object SNSTopicArn extends Subtype[String]
    type SNSTopicArn = zio.aws.textract.model.primitives.SNSTopicArn.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage = zio.aws.textract.model.primitives.StatusMessage.Type
    object UInteger extends Subtype[Int]
    type UInteger = zio.aws.textract.model.primitives.UInteger.Type
  }
  type BlockList = List[zio.aws.textract.model.Block]
  type ContentClassifiers = List[zio.aws.textract.model.ContentClassifier]
  type DetectedSignatureList = List[zio.aws.textract.model.DetectedSignature]
  type DocumentGroupList = List[zio.aws.textract.model.DocumentGroup]
  type DocumentPages = List[zio.aws.textract.model.Document]
  type EntityTypes = List[zio.aws.textract.model.EntityType]
  type ExpenseDocumentList = List[zio.aws.textract.model.ExpenseDocument]
  type ExpenseFieldList = List[zio.aws.textract.model.ExpenseField]
  type ExpenseGroupPropertyList =
    List[zio.aws.textract.model.ExpenseGroupProperty]
  type ExtractionList = List[zio.aws.textract.model.Extraction]
  type FeatureTypes = List[zio.aws.textract.model.FeatureType]
  type HumanLoopActivationReasons = List[HumanLoopActivationReason]
  type IdList = List[NonEmptyString]
  type IdentityDocumentFieldList =
    List[zio.aws.textract.model.IdentityDocumentField]
  type IdentityDocumentList = List[zio.aws.textract.model.IdentityDocument]
  type LendingDetectionList = List[zio.aws.textract.model.LendingDetection]
  type LendingFieldList = List[zio.aws.textract.model.LendingField]
  type LendingResultList = List[zio.aws.textract.model.LendingResult]
  type LineItemGroupList = List[zio.aws.textract.model.LineItemGroup]
  type LineItemList = List[zio.aws.textract.model.LineItemFields]
  type PageList = List[UInteger]
  type Pages = List[UInteger]
  type Polygon = List[zio.aws.textract.model.Point]
  type PredictionList = List[zio.aws.textract.model.Prediction]
  type Queries = List[zio.aws.textract.model.Query]
  type QueryPages = List[QueryPage]
  type RelationshipList = List[zio.aws.textract.model.Relationship]
  type SignatureDetectionList = List[zio.aws.textract.model.SignatureDetection]
  type SplitDocumentList = List[zio.aws.textract.model.SplitDocument]
  type StringList = List[String]
  type UndetectedDocumentTypeList = List[NonEmptyString]
  type UndetectedSignatureList =
    List[zio.aws.textract.model.UndetectedSignature]
  type Warnings = List[zio.aws.textract.model.Warning]
}
