package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.Percent
import scala.jdk.CollectionConverters._
final case class SignatureDetection(
    confidence: Optional[Percent] = Optional.Absent,
    geometry: Optional[zio.aws.textract.model.Geometry] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.SignatureDetection = {
    import SignatureDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.SignatureDetection
      .builder()
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.SignatureDetection.ReadOnly =
    zio.aws.textract.model.SignatureDetection.wrap(buildAwsValue())
}
object SignatureDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.SignatureDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.SignatureDetection =
      zio.aws.textract.model.SignatureDetection(
        confidence.map(value => value),
        geometry.map(value => value.asEditable)
      )
    def confidence: Optional[Percent]
    def geometry: Optional[zio.aws.textract.model.Geometry.ReadOnly]
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.textract.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.SignatureDetection
  ) extends zio.aws.textract.model.SignatureDetection.ReadOnly {
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
    override val geometry: Optional[zio.aws.textract.model.Geometry.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.geometry())
        .map(value => zio.aws.textract.model.Geometry.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.SignatureDetection
  ): zio.aws.textract.model.SignatureDetection.ReadOnly = new Wrapper(impl)
}
