package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{Percent, NonEmptyString}
import scala.jdk.CollectionConverters._
final case class Prediction(
    value: Optional[NonEmptyString] = Optional.Absent,
    confidence: Optional[Percent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.Prediction = {
    import Prediction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Prediction
      .builder()
      .optionallyWith(
        value.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Prediction.ReadOnly =
    zio.aws.textract.model.Prediction.wrap(buildAwsValue())
}
object Prediction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.Prediction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Prediction = zio.aws.textract.model
      .Prediction(value.map(value => value), confidence.map(value => value))
    def value: Optional[NonEmptyString]
    def confidence: Optional[Percent]
    def getValue: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("value", value)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Prediction
  ) extends zio.aws.textract.model.Prediction.ReadOnly {
    override val value: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.textract.model.primitives.NonEmptyString(value))
    override val confidence: Optional[Percent] = zio.aws.core.internal
      .optionalFromNullable(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Prediction
  ): zio.aws.textract.model.Prediction.ReadOnly = new Wrapper(impl)
}
