package zio.aws.textract.model
import zio.aws.textract.model.primitives.{PaginationToken, MaxResults, JobId}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetDocumentTextDetectionRequest(
    jobId: JobId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest = {
    import GetDocumentTextDetectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.GetDocumentTextDetectionRequest.ReadOnly =
    zio.aws.textract.model.GetDocumentTextDetectionRequest.wrap(buildAwsValue())
}
object GetDocumentTextDetectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetDocumentTextDetectionRequest =
      zio.aws.textract.model.GetDocumentTextDetectionRequest(
        jobId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def jobId: JobId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest
  ) extends zio.aws.textract.model.GetDocumentTextDetectionRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.textract.model.primitives.JobId(impl.jobId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.textract.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionRequest
  ): zio.aws.textract.model.GetDocumentTextDetectionRequest.ReadOnly =
    new Wrapper(impl)
}
