package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{StatusMessage, PaginationToken}
import scala.jdk.CollectionConverters._
final case class GetDocumentTextDetectionResponse(
    documentMetadata: Optional[zio.aws.textract.model.DocumentMetadata] =
      Optional.Absent,
    jobStatus: Optional[zio.aws.textract.model.JobStatus] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent,
    blocks: Optional[Iterable[zio.aws.textract.model.Block]] = Optional.Absent,
    warnings: Optional[Iterable[zio.aws.textract.model.Warning]] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    detectDocumentTextModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse = {
    import GetDocumentTextDetectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        blocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocks)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        detectDocumentTextModelVersion.map(value => value: java.lang.String)
      )(_.detectDocumentTextModelVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly =
    zio.aws.textract.model.GetDocumentTextDetectionResponse
      .wrap(buildAwsValue())
}
object GetDocumentTextDetectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetDocumentTextDetectionResponse =
      zio.aws.textract.model.GetDocumentTextDetectionResponse(
        documentMetadata.map(value => value.asEditable),
        jobStatus.map(value => value),
        nextToken.map(value => value),
        blocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value),
        detectDocumentTextModelVersion.map(value => value)
      )
    def documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def jobStatus: Optional[zio.aws.textract.model.JobStatus]
    def nextToken: Optional[PaginationToken]
    def blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]]
    def warnings: Optional[List[zio.aws.textract.model.Warning.ReadOnly]]
    def statusMessage: Optional[StatusMessage]
    def detectDocumentTextModelVersion: Optional[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.textract.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getBlocks
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Block.ReadOnly]] =
      AwsError.unwrapOptionField("blocks", blocks)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getDetectDocumentTextModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "detectDocumentTextModelVersion",
        detectDocumentTextModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
  ) extends zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly {
    override val documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val jobStatus: Optional[zio.aws.textract.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.textract.model.JobStatus.wrap(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
    override val blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Block.wrap(item)
          }.toList
        )
    override val warnings
        : Optional[List[zio.aws.textract.model.Warning.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Warning.wrap(item)
          }.toList
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.textract.model.primitives.StatusMessage(value))
    override val detectDocumentTextModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detectDocumentTextModelVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetDocumentTextDetectionResponse
  ): zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly =
    new Wrapper(impl)
}
