package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DetectDocumentTextResponse(
    documentMetadata: Optional[zio.aws.textract.model.DocumentMetadata] =
      Optional.Absent,
    blocks: Optional[Iterable[zio.aws.textract.model.Block]] = Optional.Absent,
    detectDocumentTextModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse = {
    import DetectDocumentTextResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(
        blocks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.blocks)
      .optionallyWith(
        detectDocumentTextModelVersion.map(value => value: java.lang.String)
      )(_.detectDocumentTextModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.DetectDocumentTextResponse.ReadOnly =
    zio.aws.textract.model.DetectDocumentTextResponse.wrap(buildAwsValue())
}
object DetectDocumentTextResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.DetectDocumentTextResponse =
      zio.aws.textract.model.DetectDocumentTextResponse(
        documentMetadata.map(value => value.asEditable),
        blocks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        detectDocumentTextModelVersion.map(value => value)
      )
    def documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]]
    def detectDocumentTextModelVersion: Optional[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getBlocks
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Block.ReadOnly]] =
      AwsError.unwrapOptionField("blocks", blocks)
    def getDetectDocumentTextModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "detectDocumentTextModelVersion",
        detectDocumentTextModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse
  ) extends zio.aws.textract.model.DetectDocumentTextResponse.ReadOnly {
    override val documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val blocks: Optional[List[zio.aws.textract.model.Block.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.blocks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Block.wrap(item)
          }.toList
        )
    override val detectDocumentTextModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.detectDocumentTextModelVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.DetectDocumentTextResponse
  ): zio.aws.textract.model.DetectDocumentTextResponse.ReadOnly = new Wrapper(
    impl
  )
}
