package zio.aws.textract
import zio.aws.textract.model.DetectDocumentTextResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.{StreamingOutputResult, AwsError}
import software.amazon.awssdk.services.textract.TextractAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.aws.textract.model.{
  StartDocumentTextDetectionRequest,
  GetDocumentAnalysisRequest,
  AnalyzeExpenseRequest,
  GetDocumentTextDetectionRequest,
  AnalyzeIdRequest,
  StartDocumentAnalysisRequest,
  DetectDocumentTextRequest,
  AnalyzeDocumentRequest,
  GetExpenseAnalysisRequest,
  StartExpenseAnalysisRequest
}
object TextractMock extends Mock[Textract] {
  object StartExpenseAnalysis
      extends Effect[
        StartExpenseAnalysisRequest,
        AwsError,
        zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
      ]
  object GetDocumentAnalysis
      extends Effect[
        GetDocumentAnalysisRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
          zio.aws.textract.model.Block.ReadOnly
        ]
      ]
  object GetDocumentAnalysisPaginated
      extends Effect[
        GetDocumentAnalysisRequest,
        AwsError,
        zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
      ]
  object AnalyzeExpense
      extends Effect[
        AnalyzeExpenseRequest,
        AwsError,
        zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly
      ]
  object DetectDocumentText
      extends Effect[DetectDocumentTextRequest, AwsError, ReadOnly]
  object StartDocumentAnalysis
      extends Effect[
        StartDocumentAnalysisRequest,
        AwsError,
        zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
      ]
  object AnalyzeDocument
      extends Effect[
        AnalyzeDocumentRequest,
        AwsError,
        zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly
      ]
  object GetExpenseAnalysis
      extends Effect[
        GetExpenseAnalysisRequest,
        AwsError,
        zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
      ]
  object AnalyzeID
      extends Effect[
        AnalyzeIdRequest,
        AwsError,
        zio.aws.textract.model.AnalyzeIdResponse.ReadOnly
      ]
  object StartDocumentTextDetection
      extends Effect[
        StartDocumentTextDetectionRequest,
        AwsError,
        zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
      ]
  object GetDocumentTextDetection
      extends Effect[
        GetDocumentTextDetectionRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
          zio.aws.textract.model.Block.ReadOnly
        ]
      ]
  object GetDocumentTextDetectionPaginated
      extends Effect[
        GetDocumentTextDetectionRequest,
        AwsError,
        zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Textract] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Textract {
          val api: TextractAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Textract = this
          def startExpenseAnalysis(request: StartExpenseAnalysisRequest): IO[
            AwsError,
            zio.aws.textract.model.StartExpenseAnalysisResponse.ReadOnly
          ] = proxy(StartExpenseAnalysis, request)
          def getDocumentAnalysis(
              request: GetDocumentAnalysisRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly,
            zio.aws.textract.model.Block.ReadOnly
          ]] = proxy(GetDocumentAnalysis, request)
          def getDocumentAnalysisPaginated(
              request: GetDocumentAnalysisRequest
          ): IO[
            AwsError,
            zio.aws.textract.model.GetDocumentAnalysisResponse.ReadOnly
          ] = proxy(GetDocumentAnalysisPaginated, request)
          def analyzeExpense(request: AnalyzeExpenseRequest): IO[
            AwsError,
            zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly
          ] = proxy(AnalyzeExpense, request)
          def detectDocumentText(
              request: DetectDocumentTextRequest
          ): IO[AwsError, ReadOnly] = proxy(DetectDocumentText, request)
          def startDocumentAnalysis(request: StartDocumentAnalysisRequest): IO[
            AwsError,
            zio.aws.textract.model.StartDocumentAnalysisResponse.ReadOnly
          ] = proxy(StartDocumentAnalysis, request)
          def analyzeDocument(request: AnalyzeDocumentRequest): IO[
            AwsError,
            zio.aws.textract.model.AnalyzeDocumentResponse.ReadOnly
          ] = proxy(AnalyzeDocument, request)
          def getExpenseAnalysis(request: GetExpenseAnalysisRequest): IO[
            AwsError,
            zio.aws.textract.model.GetExpenseAnalysisResponse.ReadOnly
          ] = proxy(GetExpenseAnalysis, request)
          def analyzeID(
              request: AnalyzeIdRequest
          ): IO[AwsError, zio.aws.textract.model.AnalyzeIdResponse.ReadOnly] =
            proxy(AnalyzeID, request)
          def startDocumentTextDetection(
              request: StartDocumentTextDetectionRequest
          ): IO[
            AwsError,
            zio.aws.textract.model.StartDocumentTextDetectionResponse.ReadOnly
          ] = proxy(StartDocumentTextDetection, request)
          def getDocumentTextDetection(
              request: GetDocumentTextDetectionRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly,
            zio.aws.textract.model.Block.ReadOnly
          ]] = proxy(GetDocumentTextDetection, request)
          def getDocumentTextDetectionPaginated(
              request: GetDocumentTextDetectionRequest
          ): IO[
            AwsError,
            zio.aws.textract.model.GetDocumentTextDetectionResponse.ReadOnly
          ] = proxy(GetDocumentTextDetectionPaginated, request)
        }
      }
    }
  }
}
