package zio.aws.textract.model
import scala.jdk.CollectionConverters._
sealed trait RelationshipType {
  def unwrap: software.amazon.awssdk.services.textract.model.RelationshipType
}
object RelationshipType {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.RelationshipType
  ): zio.aws.textract.model.RelationshipType = value match {
    case software.amazon.awssdk.services.textract.model.RelationshipType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.RelationshipType.VALUE =>
      val r = VALUE
      r
    case software.amazon.awssdk.services.textract.model.RelationshipType.CHILD =>
      val r = CHILD
      r
    case software.amazon.awssdk.services.textract.model.RelationshipType.COMPLEX_FEATURES =>
      val r = COMPLEX_FEATURES
      r
    case software.amazon.awssdk.services.textract.model.RelationshipType.MERGED_CELL =>
      val r = MERGED_CELL
      r
    case software.amazon.awssdk.services.textract.model.RelationshipType.TITLE =>
      val r = TITLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.textract.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.RelationshipType =
      software.amazon.awssdk.services.textract.model.RelationshipType.UNKNOWN_TO_SDK_VERSION
  }
  case object VALUE extends zio.aws.textract.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.RelationshipType =
      software.amazon.awssdk.services.textract.model.RelationshipType.VALUE
  }
  case object CHILD extends zio.aws.textract.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.RelationshipType =
      software.amazon.awssdk.services.textract.model.RelationshipType.CHILD
  }
  case object COMPLEX_FEATURES extends zio.aws.textract.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.RelationshipType =
      software.amazon.awssdk.services.textract.model.RelationshipType.COMPLEX_FEATURES
  }
  case object MERGED_CELL extends zio.aws.textract.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.RelationshipType =
      software.amazon.awssdk.services.textract.model.RelationshipType.MERGED_CELL
  }
  case object TITLE extends zio.aws.textract.model.RelationshipType {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.RelationshipType =
      software.amazon.awssdk.services.textract.model.RelationshipType.TITLE
  }
}
