package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.Percent
import scala.jdk.CollectionConverters._
final case class ExpenseDetection(
    text: Option[String] = None,
    geometry: Option[zio.aws.textract.model.Geometry] = None,
    confidence: Option[Percent] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseDetection = {
    import ExpenseDetection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseDetection
      .builder()
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseDetection.ReadOnly =
    zio.aws.textract.model.ExpenseDetection.wrap(buildAwsValue())
}
object ExpenseDetection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseDetection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseDetection =
      zio.aws.textract.model.ExpenseDetection(
        text.map(value => value),
        geometry.map(value => value.asEditable),
        confidence.map(value => value)
      )
    def text: Option[String]
    def geometry: Option[zio.aws.textract.model.Geometry.ReadOnly]
    def confidence: Option[Percent]
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.textract.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDetection
  ) extends zio.aws.textract.model.ExpenseDetection.ReadOnly {
    override val text: Option[String] =
      scala.Option(impl.text()).map(value => value: String)
    override val geometry: Option[zio.aws.textract.model.Geometry.ReadOnly] =
      scala
        .Option(impl.geometry())
        .map(value => zio.aws.textract.model.Geometry.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDetection
  ): zio.aws.textract.model.ExpenseDetection.ReadOnly = new Wrapper(impl)
}
