package zio.aws.textract.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.UInteger
import scala.jdk.CollectionConverters._
final case class ExpenseDocument(
    expenseIndex: Option[UInteger] = None,
    summaryFields: Option[Iterable[zio.aws.textract.model.ExpenseField]] = None,
    lineItemGroups: Option[Iterable[zio.aws.textract.model.LineItemGroup]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ExpenseDocument = {
    import ExpenseDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ExpenseDocument
      .builder()
      .optionallyWith(
        expenseIndex.map(value => UInteger.unwrap(value): Integer)
      )(_.expenseIndex)
      .optionallyWith(
        summaryFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.summaryFields)
      .optionallyWith(
        lineItemGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineItemGroups)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ExpenseDocument.ReadOnly =
    zio.aws.textract.model.ExpenseDocument.wrap(buildAwsValue())
}
object ExpenseDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ExpenseDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ExpenseDocument =
      zio.aws.textract.model.ExpenseDocument(
        expenseIndex.map(value => value),
        summaryFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lineItemGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def expenseIndex: Option[UInteger]
    def summaryFields
        : Option[List[zio.aws.textract.model.ExpenseField.ReadOnly]]
    def lineItemGroups
        : Option[List[zio.aws.textract.model.LineItemGroup.ReadOnly]]
    def getExpenseIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("expenseIndex", expenseIndex)
    def getSummaryFields: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseField.ReadOnly
    ]] = AwsError.unwrapOptionField("summaryFields", summaryFields)
    def getLineItemGroups: ZIO[Any, AwsError, List[
      zio.aws.textract.model.LineItemGroup.ReadOnly
    ]] = AwsError.unwrapOptionField("lineItemGroups", lineItemGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDocument
  ) extends zio.aws.textract.model.ExpenseDocument.ReadOnly {
    override val expenseIndex: Option[UInteger] = scala
      .Option(impl.expenseIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val summaryFields
        : Option[List[zio.aws.textract.model.ExpenseField.ReadOnly]] = scala
      .Option(impl.summaryFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.ExpenseField.wrap(item)
        }.toList
      )
    override val lineItemGroups
        : Option[List[zio.aws.textract.model.LineItemGroup.ReadOnly]] = scala
      .Option(impl.lineItemGroups())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.LineItemGroup.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ExpenseDocument
  ): zio.aws.textract.model.ExpenseDocument.ReadOnly = new Wrapper(impl)
}
