package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AnalyzeExpenseRequest(
    document: zio.aws.textract.model.Document
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest = {
    import AnalyzeExpenseRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest
      .builder()
      .document(document.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeExpenseRequest.ReadOnly =
    zio.aws.textract.model.AnalyzeExpenseRequest.wrap(buildAwsValue())
}
object AnalyzeExpenseRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeExpenseRequest =
      zio.aws.textract.model.AnalyzeExpenseRequest(document.asEditable)
    def document: zio.aws.textract.model.Document.ReadOnly
    def getDocument
        : ZIO[Any, Nothing, zio.aws.textract.model.Document.ReadOnly] =
      ZIO.succeed(document)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest
  ) extends zio.aws.textract.model.AnalyzeExpenseRequest.ReadOnly {
    override val document: zio.aws.textract.model.Document.ReadOnly =
      zio.aws.textract.model.Document.wrap(impl.document())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeExpenseRequest
  ): zio.aws.textract.model.AnalyzeExpenseRequest.ReadOnly = new Wrapper(impl)
}
