package zio.aws.textract.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.UInteger
import scala.jdk.CollectionConverters._
final case class LineItemGroup(
    lineItemGroupIndex: Option[UInteger] = None,
    lineItems: Option[Iterable[zio.aws.textract.model.LineItemFields]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.LineItemGroup = {
    import LineItemGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.LineItemGroup
      .builder()
      .optionallyWith(
        lineItemGroupIndex.map(value => UInteger.unwrap(value): Integer)
      )(_.lineItemGroupIndex)
      .optionallyWith(
        lineItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineItems)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.LineItemGroup.ReadOnly =
    zio.aws.textract.model.LineItemGroup.wrap(buildAwsValue())
}
object LineItemGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.LineItemGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.LineItemGroup =
      zio.aws.textract.model.LineItemGroup(
        lineItemGroupIndex.map(value => value),
        lineItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lineItemGroupIndex: Option[UInteger]
    def lineItems: Option[List[zio.aws.textract.model.LineItemFields.ReadOnly]]
    def getLineItemGroupIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("lineItemGroupIndex", lineItemGroupIndex)
    def getLineItems: ZIO[Any, AwsError, List[
      zio.aws.textract.model.LineItemFields.ReadOnly
    ]] = AwsError.unwrapOptionField("lineItems", lineItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.LineItemGroup
  ) extends zio.aws.textract.model.LineItemGroup.ReadOnly {
    override val lineItemGroupIndex: Option[UInteger] = scala
      .Option(impl.lineItemGroupIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val lineItems
        : Option[List[zio.aws.textract.model.LineItemFields.ReadOnly]] = scala
      .Option(impl.lineItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.LineItemFields.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.LineItemGroup
  ): zio.aws.textract.model.LineItemGroup.ReadOnly = new Wrapper(impl)
}
