package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalyzeIdResponse(
    identityDocuments: Option[
      Iterable[zio.aws.textract.model.IdentityDocument]
    ] = None,
    documentMetadata: Option[zio.aws.textract.model.DocumentMetadata] = None,
    analyzeIDModelVersion: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeIdResponse = {
    import AnalyzeIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeIdResponse
      .builder()
      .optionallyWith(
        identityDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.identityDocuments)
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(
        analyzeIDModelVersion.map(value => value: java.lang.String)
      )(_.analyzeIDModelVersion)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeIdResponse.ReadOnly =
    zio.aws.textract.model.AnalyzeIdResponse.wrap(buildAwsValue())
}
object AnalyzeIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeIdResponse =
      zio.aws.textract.model.AnalyzeIdResponse(
        identityDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentMetadata.map(value => value.asEditable),
        analyzeIDModelVersion.map(value => value)
      )
    def identityDocuments
        : Option[List[zio.aws.textract.model.IdentityDocument.ReadOnly]]
    def documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def analyzeIDModelVersion: Option[String]
    def getIdentityDocuments: ZIO[Any, AwsError, List[
      zio.aws.textract.model.IdentityDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("identityDocuments", identityDocuments)
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getAnalyzeIDModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("analyzeIDModelVersion", analyzeIDModelVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeIdResponse
  ) extends zio.aws.textract.model.AnalyzeIdResponse.ReadOnly {
    override val identityDocuments
        : Option[List[zio.aws.textract.model.IdentityDocument.ReadOnly]] = scala
      .Option(impl.identityDocuments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.IdentityDocument.wrap(item)
        }.toList
      )
    override val documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly] = scala
      .Option(impl.documentMetadata())
      .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val analyzeIDModelVersion: Option[String] =
      scala.Option(impl.analyzeIDModelVersion()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeIdResponse
  ): zio.aws.textract.model.AnalyzeIdResponse.ReadOnly = new Wrapper(impl)
}
