package zio.aws.textract.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.textract.model.primitives.{NonEmptyString, UInteger, Percent}
import scala.jdk.CollectionConverters._
final case class Block(
    blockType: Option[zio.aws.textract.model.BlockType] = None,
    confidence: Option[Percent] = None,
    text: Option[String] = None,
    textType: Option[zio.aws.textract.model.TextType] = None,
    rowIndex: Option[UInteger] = None,
    columnIndex: Option[UInteger] = None,
    rowSpan: Option[UInteger] = None,
    columnSpan: Option[UInteger] = None,
    geometry: Option[zio.aws.textract.model.Geometry] = None,
    id: Option[NonEmptyString] = None,
    relationships: Option[Iterable[zio.aws.textract.model.Relationship]] = None,
    entityTypes: Option[Iterable[zio.aws.textract.model.EntityType]] = None,
    selectionStatus: Option[zio.aws.textract.model.SelectionStatus] = None,
    page: Option[UInteger] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.textract.model.Block = {
    import Block.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.Block
      .builder()
      .optionallyWith(blockType.map(value => value.unwrap))(_.blockType)
      .optionallyWith(
        confidence.map(value => Percent.unwrap(value): java.lang.Float)
      )(_.confidence)
      .optionallyWith(text.map(value => value: java.lang.String))(_.text)
      .optionallyWith(textType.map(value => value.unwrap))(_.textType)
      .optionallyWith(rowIndex.map(value => UInteger.unwrap(value): Integer))(
        _.rowIndex
      )
      .optionallyWith(
        columnIndex.map(value => UInteger.unwrap(value): Integer)
      )(_.columnIndex)
      .optionallyWith(rowSpan.map(value => UInteger.unwrap(value): Integer))(
        _.rowSpan
      )
      .optionallyWith(columnSpan.map(value => UInteger.unwrap(value): Integer))(
        _.columnSpan
      )
      .optionallyWith(geometry.map(value => value.buildAwsValue()))(_.geometry)
      .optionallyWith(
        id.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        relationships.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.relationships)
      .optionallyWith(
        entityTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.entityTypesWithStrings)
      .optionallyWith(selectionStatus.map(value => value.unwrap))(
        _.selectionStatus
      )
      .optionallyWith(page.map(value => UInteger.unwrap(value): Integer))(
        _.page
      )
      .build()
  }
  def asReadOnly: zio.aws.textract.model.Block.ReadOnly =
    zio.aws.textract.model.Block.wrap(buildAwsValue())
}
object Block {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.textract.model.Block] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.Block = zio.aws.textract.model.Block(
      blockType.map(value => value),
      confidence.map(value => value),
      text.map(value => value),
      textType.map(value => value),
      rowIndex.map(value => value),
      columnIndex.map(value => value),
      rowSpan.map(value => value),
      columnSpan.map(value => value),
      geometry.map(value => value.asEditable),
      id.map(value => value),
      relationships.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      entityTypes.map(value => value),
      selectionStatus.map(value => value),
      page.map(value => value)
    )
    def blockType: Option[zio.aws.textract.model.BlockType]
    def confidence: Option[Percent]
    def text: Option[String]
    def textType: Option[zio.aws.textract.model.TextType]
    def rowIndex: Option[UInteger]
    def columnIndex: Option[UInteger]
    def rowSpan: Option[UInteger]
    def columnSpan: Option[UInteger]
    def geometry: Option[zio.aws.textract.model.Geometry.ReadOnly]
    def id: Option[NonEmptyString]
    def relationships
        : Option[List[zio.aws.textract.model.Relationship.ReadOnly]]
    def entityTypes: Option[List[zio.aws.textract.model.EntityType]]
    def selectionStatus: Option[zio.aws.textract.model.SelectionStatus]
    def page: Option[UInteger]
    def getBlockType: ZIO[Any, AwsError, zio.aws.textract.model.BlockType] =
      AwsError.unwrapOptionField("blockType", blockType)
    def getConfidence: ZIO[Any, AwsError, Percent] =
      AwsError.unwrapOptionField("confidence", confidence)
    def getText: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("text", text)
    def getTextType: ZIO[Any, AwsError, zio.aws.textract.model.TextType] =
      AwsError.unwrapOptionField("textType", textType)
    def getRowIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("rowIndex", rowIndex)
    def getColumnIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("columnIndex", columnIndex)
    def getRowSpan: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("rowSpan", rowSpan)
    def getColumnSpan: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("columnSpan", columnSpan)
    def getGeometry
        : ZIO[Any, AwsError, zio.aws.textract.model.Geometry.ReadOnly] =
      AwsError.unwrapOptionField("geometry", geometry)
    def getId: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("id", id)
    def getRelationships: ZIO[Any, AwsError, List[
      zio.aws.textract.model.Relationship.ReadOnly
    ]] = AwsError.unwrapOptionField("relationships", relationships)
    def getEntityTypes
        : ZIO[Any, AwsError, List[zio.aws.textract.model.EntityType]] =
      AwsError.unwrapOptionField("entityTypes", entityTypes)
    def getSelectionStatus
        : ZIO[Any, AwsError, zio.aws.textract.model.SelectionStatus] =
      AwsError.unwrapOptionField("selectionStatus", selectionStatus)
    def getPage: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("page", page)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.Block
  ) extends zio.aws.textract.model.Block.ReadOnly {
    override val blockType: Option[zio.aws.textract.model.BlockType] = scala
      .Option(impl.blockType())
      .map(value => zio.aws.textract.model.BlockType.wrap(value))
    override val confidence: Option[Percent] = scala
      .Option(impl.confidence())
      .map(value => zio.aws.textract.model.primitives.Percent(value))
    override val text: Option[String] =
      scala.Option(impl.text()).map(value => value: String)
    override val textType: Option[zio.aws.textract.model.TextType] = scala
      .Option(impl.textType())
      .map(value => zio.aws.textract.model.TextType.wrap(value))
    override val rowIndex: Option[UInteger] = scala
      .Option(impl.rowIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val columnIndex: Option[UInteger] = scala
      .Option(impl.columnIndex())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val rowSpan: Option[UInteger] = scala
      .Option(impl.rowSpan())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val columnSpan: Option[UInteger] = scala
      .Option(impl.columnSpan())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val geometry: Option[zio.aws.textract.model.Geometry.ReadOnly] =
      scala
        .Option(impl.geometry())
        .map(value => zio.aws.textract.model.Geometry.wrap(value))
    override val id: Option[NonEmptyString] = scala
      .Option(impl.id())
      .map(value => zio.aws.textract.model.primitives.NonEmptyString(value))
    override val relationships
        : Option[List[zio.aws.textract.model.Relationship.ReadOnly]] = scala
      .Option(impl.relationships())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.Relationship.wrap(item)
        }.toList
      )
    override val entityTypes: Option[List[zio.aws.textract.model.EntityType]] =
      scala
        .Option(impl.entityTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.EntityType.wrap(item)
          }.toList
        )
    override val selectionStatus
        : Option[zio.aws.textract.model.SelectionStatus] = scala
      .Option(impl.selectionStatus())
      .map(value => zio.aws.textract.model.SelectionStatus.wrap(value))
    override val page: Option[UInteger] = scala
      .Option(impl.page())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.Block
  ): zio.aws.textract.model.Block.ReadOnly = new Wrapper(impl)
}
