package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AnalyzeExpenseResponse(
    documentMetadata: Option[zio.aws.textract.model.DocumentMetadata] = None,
    expenseDocuments: Option[Iterable[zio.aws.textract.model.ExpenseDocument]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse = {
    import AnalyzeExpenseResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(
        expenseDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.expenseDocuments)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly =
    zio.aws.textract.model.AnalyzeExpenseResponse.wrap(buildAwsValue())
}
object AnalyzeExpenseResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.AnalyzeExpenseResponse =
      zio.aws.textract.model.AnalyzeExpenseResponse(
        documentMetadata.map(value => value.asEditable),
        expenseDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def expenseDocuments
        : Option[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getExpenseDocuments: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("expenseDocuments", expenseDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
  ) extends zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly {
    override val documentMetadata
        : Option[zio.aws.textract.model.DocumentMetadata.ReadOnly] = scala
      .Option(impl.documentMetadata())
      .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val expenseDocuments
        : Option[List[zio.aws.textract.model.ExpenseDocument.ReadOnly]] = scala
      .Option(impl.expenseDocuments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.ExpenseDocument.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.AnalyzeExpenseResponse
  ): zio.aws.textract.model.AnalyzeExpenseResponse.ReadOnly = new Wrapper(impl)
}
