package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class LineItemFields(
    lineItemExpenseFields: Option[
      Iterable[zio.aws.textract.model.ExpenseField]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.LineItemFields = {
    import LineItemFields.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.LineItemFields
      .builder()
      .optionallyWith(
        lineItemExpenseFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lineItemExpenseFields)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.LineItemFields.ReadOnly =
    zio.aws.textract.model.LineItemFields.wrap(buildAwsValue())
}
object LineItemFields {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.LineItemFields
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.LineItemFields =
      zio.aws.textract.model.LineItemFields(
        lineItemExpenseFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def lineItemExpenseFields
        : Option[List[zio.aws.textract.model.ExpenseField.ReadOnly]]
    def getLineItemExpenseFields: ZIO[Any, AwsError, List[
      zio.aws.textract.model.ExpenseField.ReadOnly
    ]] =
      AwsError.unwrapOptionField("lineItemExpenseFields", lineItemExpenseFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.LineItemFields
  ) extends zio.aws.textract.model.LineItemFields.ReadOnly {
    override val lineItemExpenseFields
        : Option[List[zio.aws.textract.model.ExpenseField.ReadOnly]] = scala
      .Option(impl.lineItemExpenseFields())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.ExpenseField.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.LineItemFields
  ): zio.aws.textract.model.LineItemFields.ReadOnly = new Wrapper(impl)
}
