package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{KMSKeyId, JobTag, ClientRequestToken}
import scala.jdk.CollectionConverters._
final case class StartLendingAnalysisRequest(
    documentLocation: zio.aws.textract.model.DocumentLocation,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    jobTag: Optional[JobTag] = Optional.Absent,
    notificationChannel: Optional[zio.aws.textract.model.NotificationChannel] =
      Optional.Absent,
    outputConfig: Optional[zio.aws.textract.model.OutputConfig] =
      Optional.Absent,
    kmsKeyId: Optional[KMSKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest = {
    import StartLendingAnalysisRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest
      .builder()
      .documentLocation(documentLocation.buildAwsValue())
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .optionallyWith(
        jobTag.map(value => JobTag.unwrap(value): java.lang.String)
      )(_.jobTag)
      .optionallyWith(notificationChannel.map(value => value.buildAwsValue()))(
        _.notificationChannel
      )
      .optionallyWith(outputConfig.map(value => value.buildAwsValue()))(
        _.outputConfig
      )
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.StartLendingAnalysisRequest.ReadOnly =
    zio.aws.textract.model.StartLendingAnalysisRequest.wrap(buildAwsValue())
}
object StartLendingAnalysisRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.StartLendingAnalysisRequest =
      zio.aws.textract.model.StartLendingAnalysisRequest(
        documentLocation.asEditable,
        clientRequestToken.map(value => value),
        jobTag.map(value => value),
        notificationChannel.map(value => value.asEditable),
        outputConfig.map(value => value.asEditable),
        kmsKeyId.map(value => value)
      )
    def documentLocation: zio.aws.textract.model.DocumentLocation.ReadOnly
    def clientRequestToken: Optional[ClientRequestToken]
    def jobTag: Optional[JobTag]
    def notificationChannel
        : Optional[zio.aws.textract.model.NotificationChannel.ReadOnly]
    def outputConfig: Optional[zio.aws.textract.model.OutputConfig.ReadOnly]
    def kmsKeyId: Optional[KMSKeyId]
    def getDocumentLocation
        : ZIO[Any, Nothing, zio.aws.textract.model.DocumentLocation.ReadOnly] =
      ZIO.succeed(documentLocation)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getJobTag: ZIO[Any, AwsError, JobTag] =
      AwsError.unwrapOptionField("jobTag", jobTag)
    def getNotificationChannel: ZIO[
      Any,
      AwsError,
      zio.aws.textract.model.NotificationChannel.ReadOnly
    ] = AwsError.unwrapOptionField("notificationChannel", notificationChannel)
    def getOutputConfig
        : ZIO[Any, AwsError, zio.aws.textract.model.OutputConfig.ReadOnly] =
      AwsError.unwrapOptionField("outputConfig", outputConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest
  ) extends zio.aws.textract.model.StartLendingAnalysisRequest.ReadOnly {
    override val documentLocation
        : zio.aws.textract.model.DocumentLocation.ReadOnly =
      zio.aws.textract.model.DocumentLocation.wrap(impl.documentLocation())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.textract.model.primitives.ClientRequestToken(value)
        )
    override val jobTag: Optional[JobTag] = zio.aws.core.internal
      .optionalFromNullable(impl.jobTag())
      .map(value => zio.aws.textract.model.primitives.JobTag(value))
    override val notificationChannel
        : Optional[zio.aws.textract.model.NotificationChannel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationChannel())
        .map(value => zio.aws.textract.model.NotificationChannel.wrap(value))
    override val outputConfig
        : Optional[zio.aws.textract.model.OutputConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputConfig())
        .map(value => zio.aws.textract.model.OutputConfig.wrap(value))
    override val kmsKeyId: Optional[KMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.textract.model.primitives.KMSKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.StartLendingAnalysisRequest
  ): zio.aws.textract.model.StartLendingAnalysisRequest.ReadOnly = new Wrapper(
    impl
  )
}
