package zio.aws.textract.model
import zio.aws.textract.model.primitives.{
  PaginationToken,
  MaxResults,
  DateTime,
  AdapterId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAdapterVersionsRequest(
    adapterId: Optional[AdapterId] = Optional.Absent,
    afterCreationTime: Optional[DateTime] = Optional.Absent,
    beforeCreationTime: Optional[DateTime] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest = {
    import ListAdapterVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest
      .builder()
      .optionallyWith(
        adapterId.map(value => AdapterId.unwrap(value): java.lang.String)
      )(_.adapterId)
      .optionallyWith(
        afterCreationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.afterCreationTime)
      .optionallyWith(
        beforeCreationTime.map(value => DateTime.unwrap(value): Instant)
      )(_.beforeCreationTime)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ListAdapterVersionsRequest.ReadOnly =
    zio.aws.textract.model.ListAdapterVersionsRequest.wrap(buildAwsValue())
}
object ListAdapterVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ListAdapterVersionsRequest =
      zio.aws.textract.model.ListAdapterVersionsRequest(
        adapterId.map(value => value),
        afterCreationTime.map(value => value),
        beforeCreationTime.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def adapterId: Optional[AdapterId]
    def afterCreationTime: Optional[DateTime]
    def beforeCreationTime: Optional[DateTime]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getAdapterId: ZIO[Any, AwsError, AdapterId] =
      AwsError.unwrapOptionField("adapterId", adapterId)
    def getAfterCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("afterCreationTime", afterCreationTime)
    def getBeforeCreationTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("beforeCreationTime", beforeCreationTime)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest
  ) extends zio.aws.textract.model.ListAdapterVersionsRequest.ReadOnly {
    override val adapterId: Optional[AdapterId] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterId())
      .map(value => zio.aws.textract.model.primitives.AdapterId(value))
    override val afterCreationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.afterCreationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val beforeCreationTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.beforeCreationTime())
      .map(value => zio.aws.textract.model.primitives.DateTime(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.textract.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ListAdapterVersionsRequest
  ): zio.aws.textract.model.ListAdapterVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
