package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.StatusMessage
import scala.jdk.CollectionConverters._
final case class GetLendingAnalysisSummaryResponse(
    documentMetadata: Optional[zio.aws.textract.model.DocumentMetadata] =
      Optional.Absent,
    jobStatus: Optional[zio.aws.textract.model.JobStatus] = Optional.Absent,
    summary: Optional[zio.aws.textract.model.LendingSummary] = Optional.Absent,
    warnings: Optional[Iterable[zio.aws.textract.model.Warning]] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    analyzeLendingModelVersion: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse = {
    import GetLendingAnalysisSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse
      .builder()
      .optionallyWith(documentMetadata.map(value => value.buildAwsValue()))(
        _.documentMetadata
      )
      .optionallyWith(jobStatus.map(value => value.unwrap))(_.jobStatus)
      .optionallyWith(summary.map(value => value.buildAwsValue()))(_.summary)
      .optionallyWith(
        warnings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.warnings)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        analyzeLendingModelVersion.map(value => value: java.lang.String)
      )(_.analyzeLendingModelVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly =
    zio.aws.textract.model.GetLendingAnalysisSummaryResponse
      .wrap(buildAwsValue())
}
object GetLendingAnalysisSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetLendingAnalysisSummaryResponse =
      zio.aws.textract.model.GetLendingAnalysisSummaryResponse(
        documentMetadata.map(value => value.asEditable),
        jobStatus.map(value => value),
        summary.map(value => value.asEditable),
        warnings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statusMessage.map(value => value),
        analyzeLendingModelVersion.map(value => value)
      )
    def documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly]
    def jobStatus: Optional[zio.aws.textract.model.JobStatus]
    def summary: Optional[zio.aws.textract.model.LendingSummary.ReadOnly]
    def warnings: Optional[List[zio.aws.textract.model.Warning.ReadOnly]]
    def statusMessage: Optional[StatusMessage]
    def analyzeLendingModelVersion: Optional[String]
    def getDocumentMetadata
        : ZIO[Any, AwsError, zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("documentMetadata", documentMetadata)
    def getJobStatus: ZIO[Any, AwsError, zio.aws.textract.model.JobStatus] =
      AwsError.unwrapOptionField("jobStatus", jobStatus)
    def getSummary
        : ZIO[Any, AwsError, zio.aws.textract.model.LendingSummary.ReadOnly] =
      AwsError.unwrapOptionField("summary", summary)
    def getWarnings
        : ZIO[Any, AwsError, List[zio.aws.textract.model.Warning.ReadOnly]] =
      AwsError.unwrapOptionField("warnings", warnings)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getAnalyzeLendingModelVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "analyzeLendingModelVersion",
        analyzeLendingModelVersion
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse
  ) extends zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly {
    override val documentMetadata
        : Optional[zio.aws.textract.model.DocumentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentMetadata())
        .map(value => zio.aws.textract.model.DocumentMetadata.wrap(value))
    override val jobStatus: Optional[zio.aws.textract.model.JobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobStatus())
        .map(value => zio.aws.textract.model.JobStatus.wrap(value))
    override val summary
        : Optional[zio.aws.textract.model.LendingSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.summary())
        .map(value => zio.aws.textract.model.LendingSummary.wrap(value))
    override val warnings
        : Optional[List[zio.aws.textract.model.Warning.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.warnings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.textract.model.Warning.wrap(item)
          }.toList
        )
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.textract.model.primitives.StatusMessage(value))
    override val analyzeLendingModelVersion: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.analyzeLendingModelVersion())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetLendingAnalysisSummaryResponse
  ): zio.aws.textract.model.GetLendingAnalysisSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
