package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.{
  AdapterId,
  ClientRequestToken,
  TagValue,
  KMSKeyId,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class CreateAdapterVersionRequest(
    adapterId: AdapterId,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent,
    datasetConfig: zio.aws.textract.model.AdapterVersionDatasetConfig,
    kmsKeyId: Optional[KMSKeyId] = Optional.Absent,
    outputConfig: zio.aws.textract.model.OutputConfig,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest = {
    import CreateAdapterVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest
      .builder()
      .adapterId(AdapterId.unwrap(adapterId): java.lang.String)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .datasetConfig(datasetConfig.buildAwsValue())
      .optionallyWith(
        kmsKeyId.map(value => KMSKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .outputConfig(outputConfig.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.CreateAdapterVersionRequest.ReadOnly =
    zio.aws.textract.model.CreateAdapterVersionRequest.wrap(buildAwsValue())
}
object CreateAdapterVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.CreateAdapterVersionRequest =
      zio.aws.textract.model.CreateAdapterVersionRequest(
        adapterId,
        clientRequestToken.map(value => value),
        datasetConfig.asEditable,
        kmsKeyId.map(value => value),
        outputConfig.asEditable,
        tags.map(value => value)
      )
    def adapterId: AdapterId
    def clientRequestToken: Optional[ClientRequestToken]
    def datasetConfig
        : zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly
    def kmsKeyId: Optional[KMSKeyId]
    def outputConfig: zio.aws.textract.model.OutputConfig.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getAdapterId: ZIO[Any, Nothing, AdapterId] = ZIO.succeed(adapterId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
    def getDatasetConfig: ZIO[
      Any,
      Nothing,
      zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly
    ] = ZIO.succeed(datasetConfig)
    def getKmsKeyId: ZIO[Any, AwsError, KMSKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getOutputConfig
        : ZIO[Any, Nothing, zio.aws.textract.model.OutputConfig.ReadOnly] =
      ZIO.succeed(outputConfig)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest
  ) extends zio.aws.textract.model.CreateAdapterVersionRequest.ReadOnly {
    override val adapterId: AdapterId =
      zio.aws.textract.model.primitives.AdapterId(impl.adapterId())
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.textract.model.primitives.ClientRequestToken(value)
        )
    override val datasetConfig
        : zio.aws.textract.model.AdapterVersionDatasetConfig.ReadOnly =
      zio.aws.textract.model.AdapterVersionDatasetConfig
        .wrap(impl.datasetConfig())
    override val kmsKeyId: Optional[KMSKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.textract.model.primitives.KMSKeyId(value))
    override val outputConfig: zio.aws.textract.model.OutputConfig.ReadOnly =
      zio.aws.textract.model.OutputConfig.wrap(impl.outputConfig())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.textract.model.primitives
              .TagKey(key) -> zio.aws.textract.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.CreateAdapterVersionRequest
  ): zio.aws.textract.model.CreateAdapterVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
