package zio.aws.textract.model
import scala.jdk.CollectionConverters._
sealed trait AdapterVersionStatus {
  def unwrap
      : software.amazon.awssdk.services.textract.model.AdapterVersionStatus
}
object AdapterVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.textract.model.AdapterVersionStatus
  ): zio.aws.textract.model.AdapterVersionStatus = value match {
    case software.amazon.awssdk.services.textract.model.AdapterVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.textract.model.AdapterVersionStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.textract.model.AdapterVersionStatus.AT_RISK =>
      val r = AT_RISK
      r
    case software.amazon.awssdk.services.textract.model.AdapterVersionStatus.DEPRECATED =>
      val r = DEPRECATED
      r
    case software.amazon.awssdk.services.textract.model.AdapterVersionStatus.CREATION_ERROR =>
      val r = CREATION_ERROR
      r
    case software.amazon.awssdk.services.textract.model.AdapterVersionStatus.CREATION_IN_PROGRESS =>
      val r = CREATION_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.textract.model.AdapterVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AdapterVersionStatus =
      software.amazon.awssdk.services.textract.model.AdapterVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.textract.model.AdapterVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AdapterVersionStatus =
      software.amazon.awssdk.services.textract.model.AdapterVersionStatus.ACTIVE
  }
  case object AT_RISK extends zio.aws.textract.model.AdapterVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AdapterVersionStatus =
      software.amazon.awssdk.services.textract.model.AdapterVersionStatus.AT_RISK
  }
  case object DEPRECATED extends zio.aws.textract.model.AdapterVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AdapterVersionStatus =
      software.amazon.awssdk.services.textract.model.AdapterVersionStatus.DEPRECATED
  }
  case object CREATION_ERROR
      extends zio.aws.textract.model.AdapterVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AdapterVersionStatus =
      software.amazon.awssdk.services.textract.model.AdapterVersionStatus.CREATION_ERROR
  }
  case object CREATION_IN_PROGRESS
      extends zio.aws.textract.model.AdapterVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.textract.model.AdapterVersionStatus =
      software.amazon.awssdk.services.textract.model.AdapterVersionStatus.CREATION_IN_PROGRESS
  }
}
