package zio.aws.textract.model
import zio.aws.textract.model.primitives.UInteger
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SplitDocument(
    index: Optional[UInteger] = Optional.Absent,
    pages: Optional[Iterable[UInteger]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.SplitDocument = {
    import SplitDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.SplitDocument
      .builder()
      .optionallyWith(index.map(value => UInteger.unwrap(value): Integer))(
        _.index
      )
      .optionallyWith(
        pages.map(value =>
          value.map { item =>
            UInteger.unwrap(item): Integer
          }.asJavaCollection
        )
      )(_.pages)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.SplitDocument.ReadOnly =
    zio.aws.textract.model.SplitDocument.wrap(buildAwsValue())
}
object SplitDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.SplitDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.SplitDocument =
      zio.aws.textract.model
        .SplitDocument(index.map(value => value), pages.map(value => value))
    def index: Optional[UInteger]
    def pages: Optional[List[UInteger]]
    def getIndex: ZIO[Any, AwsError, UInteger] =
      AwsError.unwrapOptionField("index", index)
    def getPages: ZIO[Any, AwsError, List[UInteger]] =
      AwsError.unwrapOptionField("pages", pages)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.SplitDocument
  ) extends zio.aws.textract.model.SplitDocument.ReadOnly {
    override val index: Optional[UInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.index())
      .map(value => zio.aws.textract.model.primitives.UInteger(value))
    override val pages: Optional[List[UInteger]] = zio.aws.core.internal
      .optionalFromNullable(impl.pages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.primitives.UInteger(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.SplitDocument
  ): zio.aws.textract.model.SplitDocument.ReadOnly = new Wrapper(impl)
}
