package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.textract.model.primitives.PaginationToken
import scala.jdk.CollectionConverters._
final case class ListAdapterVersionsResponse(
    adapterVersions: Optional[
      Iterable[zio.aws.textract.model.AdapterVersionOverview]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse = {
    import ListAdapterVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse
      .builder()
      .optionallyWith(
        adapterVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.adapterVersions)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly =
    zio.aws.textract.model.ListAdapterVersionsResponse.wrap(buildAwsValue())
}
object ListAdapterVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.ListAdapterVersionsResponse =
      zio.aws.textract.model.ListAdapterVersionsResponse(
        adapterVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def adapterVersions
        : Optional[List[zio.aws.textract.model.AdapterVersionOverview.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getAdapterVersions: ZIO[Any, AwsError, List[
      zio.aws.textract.model.AdapterVersionOverview.ReadOnly
    ]] = AwsError.unwrapOptionField("adapterVersions", adapterVersions)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse
  ) extends zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly {
    override val adapterVersions: Optional[
      List[zio.aws.textract.model.AdapterVersionOverview.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.adapterVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.textract.model.AdapterVersionOverview.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.textract.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.ListAdapterVersionsResponse
  ): zio.aws.textract.model.ListAdapterVersionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
