package zio.aws.textract.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.textract.model.primitives.{AdapterVersion, AdapterId}
import scala.jdk.CollectionConverters._
final case class GetAdapterVersionRequest(
    adapterId: AdapterId,
    adapterVersion: AdapterVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest = {
    import GetAdapterVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest
      .builder()
      .adapterId(AdapterId.unwrap(adapterId): java.lang.String)
      .adapterVersion(AdapterVersion.unwrap(adapterVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.textract.model.GetAdapterVersionRequest.ReadOnly =
    zio.aws.textract.model.GetAdapterVersionRequest.wrap(buildAwsValue())
}
object GetAdapterVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.textract.model.GetAdapterVersionRequest =
      zio.aws.textract.model.GetAdapterVersionRequest(adapterId, adapterVersion)
    def adapterId: AdapterId
    def adapterVersion: AdapterVersion
    def getAdapterId: ZIO[Any, Nothing, AdapterId] = ZIO.succeed(adapterId)
    def getAdapterVersion: ZIO[Any, Nothing, AdapterVersion] =
      ZIO.succeed(adapterVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest
  ) extends zio.aws.textract.model.GetAdapterVersionRequest.ReadOnly {
    override val adapterId: AdapterId =
      zio.aws.textract.model.primitives.AdapterId(impl.adapterId())
    override val adapterVersion: AdapterVersion =
      zio.aws.textract.model.primitives.AdapterVersion(impl.adapterVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.textract.model.GetAdapterVersionRequest
  ): zio.aws.textract.model.GetAdapterVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
